package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata108;
    private final Metadata metadata115;
    private final Metadata metadata111;
    private final Metadata metadata110;
    private final Metadata metadata113;
    private final Metadata metadata105;
    private final Metadata metadata107;
    private final Metadata metadata112;
    private final Metadata metadata114;
    private final Metadata metadata116;
    private final Metadata metadata109;
    private final Metadata metadata117;
    private final Metadata metadata106;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata108Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata108 = mbuiContext.metadataRegistry().lookup(metadata108Template);
        AddressTemplate metadata115Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata115 = mbuiContext.metadataRegistry().lookup(metadata115Template);
        AddressTemplate metadata111Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata111 = mbuiContext.metadataRegistry().lookup(metadata111Template);
        AddressTemplate metadata110Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata110 = mbuiContext.metadataRegistry().lookup(metadata110Template);
        AddressTemplate metadata113Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata113 = mbuiContext.metadataRegistry().lookup(metadata113Template);
        AddressTemplate metadata105Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata105 = mbuiContext.metadataRegistry().lookup(metadata105Template);
        AddressTemplate metadata107Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata107 = mbuiContext.metadataRegistry().lookup(metadata107Template);
        AddressTemplate metadata112Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata112 = mbuiContext.metadataRegistry().lookup(metadata112Template);
        AddressTemplate metadata114Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata114 = mbuiContext.metadataRegistry().lookup(metadata114Template);
        AddressTemplate metadata116Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata116 = mbuiContext.metadataRegistry().lookup(metadata116Template);
        AddressTemplate metadata109Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata109 = mbuiContext.metadataRegistry().lookup(metadata109Template);
        AddressTemplate metadata117Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata117 = mbuiContext.metadataRegistry().lookup(metadata117Template);
        AddressTemplate metadata106Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata106 = mbuiContext.metadataRegistry().lookup(metadata106Template);
        this.handlebarElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata105)
            .onSave((form, changedValues) -> saveSingletonForm("Logging Configuration", metadata105Template.resolve(mbuiContext.statementContext()), changedValues, metadata105))
            .prepareReset(form -> resetSingletonForm("Logging Configuration", metadata105Template.resolve(mbuiContext.statementContext()), form, metadata105))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata106)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Root Logger", metadata106Template.resolve(mbuiContext.statementContext()), changedValues, metadata106))
            .prepareReset(form -> resetSingletonForm("Root Logger", metadata106Template.resolve(mbuiContext.statementContext()), form, metadata106))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-categories-form", metadata107)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Category", name, metadata107Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata107);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Category", name, metadata107Template.resolve(mbuiContext.statementContext(), name), form, metadata107);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-form", metadata108)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Console Handler", name, metadata108Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata108);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Console Handler", name, metadata108Template.resolve(mbuiContext.statementContext(), name), form, metadata108);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-form", metadata109)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata109Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata109);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata109Template.resolve(mbuiContext.statementContext(), name), form, metadata109);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-form", metadata110)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Rotating File Handler", name, metadata110Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata110);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Rotating File Handler", name, metadata110Template.resolve(mbuiContext.statementContext(), name), form, metadata110);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata111)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Size Rotating File Handler", name, metadata111Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata111);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Size Rotating File Handler", name, metadata111Template.resolve(mbuiContext.statementContext(), name), form, metadata111);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-form", metadata112)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Size Rotating File Handler", name, metadata112Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata112);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Size Rotating File Handler", name, metadata112Template.resolve(mbuiContext.statementContext(), name), form, metadata112);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-form", metadata113)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Async Handler", name, metadata113Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata113);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Async Handler", name, metadata113Template.resolve(mbuiContext.statementContext(), name), form, metadata113);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-form", metadata114)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Handler", name, metadata114Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata114);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Handler", name, metadata114Template.resolve(mbuiContext.statementContext(), name), form, metadata114);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), customHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-form", metadata115)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Syslog Handler", name, metadata115Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata115);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Syslog Handler", name, metadata115Template.resolve(mbuiContext.statementContext(), name), form, metadata115);
            })
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-form", metadata117)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Formatter", name, metadata117Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata117);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Formatter", name, metadata117Template.resolve(mbuiContext.statementContext(), name), form, metadata117);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-form", metadata116)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Pattern Formatter", name, metadata116Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata116);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Pattern Formatter", name, metadata116Template.resolve(mbuiContext.statementContext(), name), form, metadata116);
            })
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-categories-table", metadata107)
            .button(mbuiContext.tableButtonFactory().add(metadata107Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-categories-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata107,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata107Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Category", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), loggerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata107Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-table", metadata108)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-console-table", Ids.ADD_SUFFIX), "Console Handler",
                metadata108Template, asList("level", "target", "formatter"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata108Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-table", metadata109)
            .button(mbuiContext.tableButtonFactory().add(metadata109Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-file-table", Ids.ADD_SUFFIX),
                    metadata109)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata109Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata109Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-table", metadata110)
            .button(mbuiContext.tableButtonFactory().add(metadata110Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-rotating-file-table", Ids.ADD_SUFFIX),
                    metadata110)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata110Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Periodic Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata110Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-table", metadata111)
            .button(mbuiContext.tableButtonFactory().add(metadata111Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-size-rotating-file-table", Ids.ADD_SUFFIX),
                    metadata111)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata111Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Periodic Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata111Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-table", metadata112)
            .button(mbuiContext.tableButtonFactory().add(metadata112Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-size-rotating-file-table", Ids.ADD_SUFFIX),
                    metadata112)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata112Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata112Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-table", metadata113)
            .button(mbuiContext.tableButtonFactory().add(metadata113Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-async-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata113,
                    asList("level", "subhandlers", "queue-length", "overflow-action"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata113Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Async Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata113Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-table", metadata114)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-custom-table", Ids.ADD_SUFFIX), "Custom Handler",
                metadata114Template, asList("level", "module", "class", "formatter"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata114Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-table", metadata115)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-syslog-table", Ids.ADD_SUFFIX), "Syslog Handler",
                metadata115Template, asList("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata115Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-table", metadata117)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-custom-table", Ids.ADD_SUFFIX), "Custom Formatter",
                metadata117Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata117Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-table", metadata116)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-pattern-table", Ids.ADD_SUFFIX), "Pattern Formatter",
                metadata116Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata116Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder loggingConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata105.getDescription().getDescription()}}</p>"))
                    .rememberAs("html311")
                .end()
                .add(loggingConfigForm)
            .end();
        Element loggingConfigItemElement = loggingConfigItemBuilder.build();
        handlebarElements.put("html311", loggingConfigItemBuilder.referenceFor("html311"));
        navigation.addPrimary("logging-config-item", "Configuration", "pficon pficon-settings", loggingConfigItemElement);
        Elements.Builder loggingRootLoggerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">{{metadata106.getDescription().getDescription()}}</p>"))
                    .rememberAs("html313")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingRootLoggerItemElement = loggingRootLoggerItemBuilder.build();
        handlebarElements.put("html313", loggingRootLoggerItemBuilder.referenceFor("html313"));
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        Elements.Builder loggingCategoriesItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata107.getDescription().getDescription()}}</p>"))
                    .rememberAs("html315")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingCategoriesItemElement = loggingCategoriesItemBuilder.build();
        handlebarElements.put("html315", loggingCategoriesItemBuilder.referenceFor("html315"));
        navigation.addPrimary("logging-categories-item", "Categories", "pficon pficon-repository", loggingCategoriesItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingHandlerConsoleItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata108.getDescription().getDescription()}}</p>"))
                    .rememberAs("html318")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingHandlerConsoleItemElement = loggingHandlerConsoleItemBuilder.build();
        handlebarElements.put("html318", loggingHandlerConsoleItemBuilder.referenceFor("html318"));
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        Elements.Builder loggingHandlerFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata109.getDescription().getDescription()}}</p>"))
                    .rememberAs("html321")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingHandlerFileItemElement = loggingHandlerFileItemBuilder.build();
        handlebarElements.put("html321", loggingHandlerFileItemBuilder.referenceFor("html321"));
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        Elements.Builder loggingHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata110.getDescription().getDescription()}}</p>"))
                    .rememberAs("html324")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingHandlerPeriodicRotatingFileItemElement = loggingHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html324", loggingHandlerPeriodicRotatingFileItemBuilder.referenceFor("html324"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata111.getDescription().getDescription()}}</p>"))
                    .rememberAs("html327")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingHandlerPeriodicSizeRotatingFileItemElement = loggingHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html327", loggingHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html327"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata112.getDescription().getDescription()}}</p>"))
                    .rememberAs("html330")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingHandlerSizeRotatingFileItemElement = loggingHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html330", loggingHandlerSizeRotatingFileItemBuilder.referenceFor("html330"));
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerAsyncItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata113.getDescription().getDescription()}}</p>"))
                    .rememberAs("html333")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingHandlerAsyncItemElement = loggingHandlerAsyncItemBuilder.build();
        handlebarElements.put("html333", loggingHandlerAsyncItemBuilder.referenceFor("html333"));
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        Elements.Builder loggingHandlerCustomItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata114.getDescription().getDescription()}}</p>"))
                    .rememberAs("html336")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingHandlerCustomItemElement = loggingHandlerCustomItemBuilder.build();
        handlebarElements.put("html336", loggingHandlerCustomItemBuilder.referenceFor("html336"));
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        Elements.Builder loggingHandlerSyslogItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata115.getDescription().getDescription()}}</p>"))
                    .rememberAs("html339")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingHandlerSyslogItemElement = loggingHandlerSyslogItemBuilder.build();
        handlebarElements.put("html339", loggingHandlerSyslogItemBuilder.referenceFor("html339"));
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingFormatterPatternItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata116.getDescription().getDescription()}}</p>"))
                    .rememberAs("html342")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingFormatterPatternItemElement = loggingFormatterPatternItemBuilder.build();
        handlebarElements.put("html342", loggingFormatterPatternItemBuilder.referenceFor("html342"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        Elements.Builder loggingFormatterCustomItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata117.getDescription().getDescription()}}</p>"))
                    .rememberAs("html345")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingFormatterCustomItemElement = loggingFormatterCustomItemBuilder.build();
        handlebarElements.put("html345", loggingFormatterCustomItemBuilder.referenceFor("html345"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html311"), "{{metadata105.getDescription().getDescription()}}", String.valueOf(metadata105.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html313"), "{{metadata106.getDescription().getDescription()}}", String.valueOf(metadata106.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html315"), "{{metadata107.getDescription().getDescription()}}", String.valueOf(metadata107.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html318"), "{{metadata108.getDescription().getDescription()}}", String.valueOf(metadata108.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html321"), "{{metadata109.getDescription().getDescription()}}", String.valueOf(metadata109.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html324"), "{{metadata110.getDescription().getDescription()}}", String.valueOf(metadata110.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html327"), "{{metadata111.getDescription().getDescription()}}", String.valueOf(metadata111.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html330"), "{{metadata112.getDescription().getDescription()}}", String.valueOf(metadata112.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html333"), "{{metadata113.getDescription().getDescription()}}", String.valueOf(metadata113.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html336"), "{{metadata114.getDescription().getDescription()}}", String.valueOf(metadata114.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html339"), "{{metadata115.getDescription().getDescription()}}", String.valueOf(metadata115.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html342"), "{{metadata116.getDescription().getDescription()}}", String.valueOf(metadata116.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html345"), "{{metadata117.getDescription().getDescription()}}", String.valueOf(metadata117.getDescription().getDescription()));
    }
}
