package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata189;
    private final Metadata metadata193;
    private final Metadata metadata191;
    private final Metadata metadata192;
    private final Metadata metadata190;
    private final Metadata metadata194;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata189Template = AddressTemplate.of("/{selected.host}");
        this.metadata189 = mbuiContext.metadataRegistry().lookup(metadata189Template);
        AddressTemplate metadata193Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata193 = mbuiContext.metadataRegistry().lookup(metadata193Template);
        AddressTemplate metadata191Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata191 = mbuiContext.metadataRegistry().lookup(metadata191Template);
        AddressTemplate metadata192Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata192 = mbuiContext.metadataRegistry().lookup(metadata192Template);
        AddressTemplate metadata190Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata190 = mbuiContext.metadataRegistry().lookup(metadata190Template);
        AddressTemplate metadata194Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata194 = mbuiContext.metadataRegistry().lookup(metadata194Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata189)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata189Template.resolve(mbuiContext.statementContext()), form, metadata189))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata190)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata190Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata190);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata190Template.resolve(mbuiContext.statementContext(), name), form, metadata190);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata191)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata191Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata191);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata191Template.resolve(mbuiContext.statementContext(), name), form, metadata191);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata192)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata192Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata192);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata192Template.resolve(mbuiContext.statementContext(), name), form, metadata192);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata193)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata193Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata193);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata193Template.resolve(mbuiContext.statementContext(), name), form, metadata193);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata194)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata194Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata194);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata194Template.resolve(mbuiContext.statementContext(), name), form, metadata194);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata190)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata190Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata190Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata191)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata191Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata191Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata192)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD_SUFFIX), "Path",
                metadata192Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata192Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata193)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD_SUFFIX), "Socket Binding Group",
                metadata193Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata193Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata194)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata194Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata194Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder hostConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata189.getDescription().getDescription()}}</p>"))
                    .rememberAs("html563")
                .end()
                .add(hostConfigurationForm)
            .end();
        Element hostConfigurationItemElement = hostConfigurationItemBuilder.build();
        handlebarElements.put("html563", hostConfigurationItemBuilder.referenceFor("html563"));
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        Elements.Builder hostInterfaceItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata190.getDescription().getDescription()}}</p>"))
                    .rememberAs("html565")
                .end()
                .add(hostInterfaceTable)
                .add(hostInterfaceForm)
            .end();
        Element hostInterfaceItemElement = hostInterfaceItemBuilder.build();
        handlebarElements.put("html565", hostInterfaceItemBuilder.referenceFor("html565"));
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        Elements.Builder hostJvmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata191.getDescription().getDescription()}}</p>"))
                    .rememberAs("html568")
                .end()
                .add(hostJvmTable)
                .add(hostJvmForm)
            .end();
        Element hostJvmItemElement = hostJvmItemBuilder.build();
        handlebarElements.put("html568", hostJvmItemBuilder.referenceFor("html568"));
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        Elements.Builder hostPathItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata192.getDescription().getDescription()}}</p>"))
                    .rememberAs("html571")
                .end()
                .add(hostPathTable)
                .add(hostPathForm)
            .end();
        Element hostPathItemElement = hostPathItemBuilder.build();
        handlebarElements.put("html571", hostPathItemBuilder.referenceFor("html571"));
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        Elements.Builder hostSocketBindingGroupItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata193.getDescription().getDescription()}}</p>"))
                    .rememberAs("html574")
                .end()
                .add(hostSocketBindingGroupTable)
                .add(hostSocketBindingGroupForm)
            .end();
        Element hostSocketBindingGroupItemElement = hostSocketBindingGroupItemBuilder.build();
        handlebarElements.put("html574", hostSocketBindingGroupItemBuilder.referenceFor("html574"));
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        Elements.Builder hostSystemPropertyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata194.getDescription().getDescription()}}</p>"))
                    .rememberAs("html577")
                .end()
                .add(hostSystemPropertyTable)
                .add(hostSystemPropertyForm)
            .end();
        Element hostSystemPropertyItemElement = hostSystemPropertyItemBuilder.build();
        handlebarElements.put("html577", hostSystemPropertyItemBuilder.referenceFor("html577"));
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html563"), "{{metadata189.getDescription().getDescription()}}", String.valueOf(metadata189.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html565"), "{{metadata190.getDescription().getDescription()}}", String.valueOf(metadata190.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html568"), "{{metadata191.getDescription().getDescription()}}", String.valueOf(metadata191.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html571"), "{{metadata192.getDescription().getDescription()}}", String.valueOf(metadata192.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html574"), "{{metadata193.getDescription().getDescription()}}", String.valueOf(metadata193.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html577"), "{{metadata194.getDescription().getDescription()}}", String.valueOf(metadata194.getDescription().getDescription()));
    }
}
