package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata21;
    private final Metadata metadata18;
    private final Metadata metadata17;
    private final Metadata metadata20;
    private final Metadata metadata19;
    private final Metadata metadata14;
    private final Metadata metadata12;
    private final Metadata metadata16;
    private final Metadata metadata11;
    private final Metadata metadata15;
    private final Metadata metadata13;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata20Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata20 = mbuiContext.metadataRegistry().lookup(metadata20Template);
        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-configuration-form", metadata11)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata11Template.resolve(mbuiContext.statementContext()), changedValues, metadata11))
            .prepareReset(form -> resetSingletonForm("Container", metadata11Template.resolve(mbuiContext.statementContext()), form, metadata11))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-thread-pool-form", metadata12)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata12Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata12);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata12Template.resolve(mbuiContext.statementContext(), name), form, metadata12);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-remoting-profile-form", metadata13)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata13Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata13);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata13Template.resolve(mbuiContext.statementContext(), name), form, metadata13);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-bean-pool-form", metadata14)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata14Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata14);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata14Template.resolve(mbuiContext.statementContext(), name), form, metadata14);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-cache-form", metadata15)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata15Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata15);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata15Template.resolve(mbuiContext.statementContext(), name), form, metadata15);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-passivation-form", metadata16)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata16Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata16);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata16Template.resolve(mbuiContext.statementContext(), name), form, metadata16);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-async-form", metadata17)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata17Template.resolve(mbuiContext.statementContext()), changedValues, metadata17))
            .prepareReset(form -> resetSingletonForm("Async", metadata17Template.resolve(mbuiContext.statementContext()), form, metadata17))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-iiop-form", metadata18)
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata18Template.resolve(mbuiContext.statementContext()), changedValues, metadata18))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata18Template.resolve(mbuiContext.statementContext()), form, metadata18))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-remote-form", metadata19)
            .include("cluster", "connector-ref", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata19Template.resolve(mbuiContext.statementContext()), changedValues, metadata19))
            .prepareReset(form -> resetSingletonForm("Remote", metadata19Template.resolve(mbuiContext.statementContext()), form, metadata19))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        serviceRemoteForm.getFormItem("connector-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*")));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-timer-form", metadata20)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata20Template.resolve(mbuiContext.statementContext()), changedValues, metadata20))
            .prepareReset(form -> resetSingletonForm("Timer", metadata20Template.resolve(mbuiContext.statementContext()), form, metadata20))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-mdb-delivery-group-form", metadata21)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata21Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata21);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata21Template.resolve(mbuiContext.statementContext(), name), form, metadata21);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-thread-pool-table", metadata12)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-thread-pool-table", Ids.ADD_SUFFIX), "Thread Pool",
                metadata12Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata12Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-remoting-profile-table", metadata13)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-remoting-profile-table", Ids.ADD_SUFFIX), "Remoting Profile",
                metadata13Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata13Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-bean-pool-table", metadata14)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-bean-pool-table", Ids.ADD_SUFFIX), "Bean Pool",
                metadata14Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata14Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-cache-table", metadata15)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-cache-table", Ids.ADD_SUFFIX), "Cache",
                metadata15Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata15Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-passivation-table", metadata16)
            .button(mbuiContext.tableButtonFactory().add(metadata16Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb-passivation-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata16,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata16Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata16Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-mdb-delivery-group-table", metadata21)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-mdb-delivery-group-table", Ids.ADD_SUFFIX), "MDB Delivery Group",
                metadata21Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata21Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb-container-item", "Container", "fa fa-cogs");
        Elements.Builder ejbConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>{{metadata11.getDescription().getDescription()}}</p>"))
                    .rememberAs("html31")
                .end()
                .add(configurationForm)
            .end();
        Element ejbConfigurationItemElement = ejbConfigurationItemBuilder.build();
        handlebarElements.put("html31", ejbConfigurationItemBuilder.referenceFor("html31"));
        navigation.addSecondary("ejb-container-item", "ejb-configuration-item", "Container", ejbConfigurationItemElement);
        Elements.Builder ejbThreadPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>{{metadata12.getDescription().getDescription()}}</p>"))
                    .rememberAs("html33")
                .end()
                .add(threadPoolTable)
                .add(threadPoolForm)
            .end();
        Element ejbThreadPoolItemElement = ejbThreadPoolItemBuilder.build();
        handlebarElements.put("html33", ejbThreadPoolItemBuilder.referenceFor("html33"));
        navigation.addSecondary("ejb-container-item", "ejb-thread-pool-item", "Thread Pool", ejbThreadPoolItemElement);
        Elements.Builder ejbRemotingProfileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>{{metadata13.getDescription().getDescription()}}</p>"))
                    .rememberAs("html36")
                .end()
                .add(remotingProfileTable)
                .add(remotingProfileForm)
            .end();
        Element ejbRemotingProfileItemElement = ejbRemotingProfileItemBuilder.build();
        handlebarElements.put("html36", ejbRemotingProfileItemBuilder.referenceFor("html36"));
        navigation.addSecondary("ejb-container-item", "ejb-remoting-profile-item", "Remoting Profile", ejbRemotingProfileItemElement);
        Elements.Builder ejbBeanPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>{{metadata14.getDescription().getDescription()}}</p>"))
                    .rememberAs("html39")
                .end()
                .add(beanPoolTable)
                .add(beanPoolForm)
            .end();
        Element ejbBeanPoolItemElement = ejbBeanPoolItemBuilder.build();
        handlebarElements.put("html39", ejbBeanPoolItemBuilder.referenceFor("html39"));
        navigation.addPrimary("ejb-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejbBeanPoolItemElement);
        navigation.addPrimary("ejb-state-item", "State Management", "fa fa-list-ul");
        Elements.Builder ejbCacheItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>{{metadata15.getDescription().getDescription()}}</p>"))
                    .rememberAs("html42")
                .end()
                .add(cacheTable)
                .add(cacheForm)
            .end();
        Element ejbCacheItemElement = ejbCacheItemBuilder.build();
        handlebarElements.put("html42", ejbCacheItemBuilder.referenceFor("html42"));
        navigation.addSecondary("ejb-state-item", "ejb-cache-item", "Cache", ejbCacheItemElement);
        Elements.Builder ejbPassivationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>{{metadata16.getDescription().getDescription()}}</p>"))
                    .rememberAs("html45")
                .end()
                .add(passivationTable)
                .add(passivationForm)
            .end();
        Element ejbPassivationItemElement = ejbPassivationItemBuilder.build();
        handlebarElements.put("html45", ejbPassivationItemBuilder.referenceFor("html45"));
        navigation.addSecondary("ejb-state-item", "ejb-passivation-item", "Passivation", ejbPassivationItemElement);
        navigation.addPrimary("ejb-service-item", "Services", "pficon pficon-service");
        Elements.Builder ejbServiceAsyncItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>{{metadata17.getDescription().getDescription()}}</p>"))
                    .rememberAs("html48")
                .end()
                .add(serviceAsyncForm)
            .end();
        Element ejbServiceAsyncItemElement = ejbServiceAsyncItemBuilder.build();
        handlebarElements.put("html48", ejbServiceAsyncItemBuilder.referenceFor("html48"));
        navigation.addSecondary("ejb-service-item", "ejb-service-async-item", "Async", ejbServiceAsyncItemElement);
        Elements.Builder ejbServiceIiopItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>{{metadata18.getDescription().getDescription()}}</p>"))
                    .rememberAs("html50")
                .end()
                .add(serviceIiopForm)
            .end();
        Element ejbServiceIiopItemElement = ejbServiceIiopItemBuilder.build();
        handlebarElements.put("html50", ejbServiceIiopItemBuilder.referenceFor("html50"));
        navigation.addSecondary("ejb-service-item", "ejb-service-iiop-item", "IIOP", ejbServiceIiopItemElement);
        Elements.Builder ejbServiceRemoteItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>{{metadata19.getDescription().getDescription()}}</p>"))
                    .rememberAs("html52")
                .end()
                .add(serviceRemoteForm)
            .end();
        Element ejbServiceRemoteItemElement = ejbServiceRemoteItemBuilder.build();
        handlebarElements.put("html52", ejbServiceRemoteItemBuilder.referenceFor("html52"));
        navigation.addSecondary("ejb-service-item", "ejb-service-remote-item", "Remote", ejbServiceRemoteItemElement);
        Elements.Builder ejbServiceTimerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>{{metadata20.getDescription().getDescription()}}</p>"))
                    .rememberAs("html54")
                .end()
                .add(serviceTimerForm)
            .end();
        Element ejbServiceTimerItemElement = ejbServiceTimerItemBuilder.build();
        handlebarElements.put("html54", ejbServiceTimerItemBuilder.referenceFor("html54"));
        navigation.addSecondary("ejb-service-item", "ejb-service-timer-item", "Timer", ejbServiceTimerItemElement);
        Elements.Builder ejbMdbDeliveryGroupItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>{{metadata21.getDescription().getDescription()}}</p>"))
                    .rememberAs("html56")
                .end()
                .add(mdbDeliveryGroupTable)
                .add(mdbDeliveryGroupForm)
            .end();
        Element ejbMdbDeliveryGroupItemElement = ejbMdbDeliveryGroupItemBuilder.build();
        handlebarElements.put("html56", ejbMdbDeliveryGroupItemBuilder.referenceFor("html56"));
        navigation.addPrimary("ejb-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejbMdbDeliveryGroupItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html31"), "{{metadata11.getDescription().getDescription()}}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html33"), "{{metadata12.getDescription().getDescription()}}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html36"), "{{metadata13.getDescription().getDescription()}}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html39"), "{{metadata14.getDescription().getDescription()}}", String.valueOf(metadata14.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html42"), "{{metadata15.getDescription().getDescription()}}", String.valueOf(metadata15.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html45"), "{{metadata16.getDescription().getDescription()}}", String.valueOf(metadata16.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html48"), "{{metadata17.getDescription().getDescription()}}", String.valueOf(metadata17.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html50"), "{{metadata18.getDescription().getDescription()}}", String.valueOf(metadata18.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html52"), "{{metadata19.getDescription().getDescription()}}", String.valueOf(metadata19.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html54"), "{{metadata20.getDescription().getDescription()}}", String.valueOf(metadata20.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html56"), "{{metadata21.getDescription().getDescription()}}", String.valueOf(metadata21.getDescription().getDescription()));
    }
}
