package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata122;
    private final Metadata metadata118;
    private final Metadata metadata120;
    private final Metadata metadata121;
    private final Metadata metadata119;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/bridge=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata118Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*");
        this.metadata118 = mbuiContext.metadataRegistry().lookup(metadata118Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata119Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*");
        this.metadata119 = mbuiContext.metadataRegistry().lookup(metadata119Template);
        this.handlebarElements = new HashMap<>();

        broadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-form", metadata118)
            .include("broadcast-period", "connectors", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BROADCAST_GROUP, form))
            .build();
        broadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-form", metadata119)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DISCOVERY_GROUP, form))
            .build();
        discoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-form", metadata120)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-form", metadata121)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();
        bridgeForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-bridge-form", metadata122)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BRIDGE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BRIDGE, form))
            .build();

        broadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-table", metadata118)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-table", metadata119)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        clusterConnectionTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-table", metadata120)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        groupingHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-table", metadata121)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.GROUPING_HANDLER), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.GROUPING_HANDLER, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        bridgeTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-bridge-table", metadata122)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addBridge(ServerSubResource.BRIDGE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/bridge=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.BRIDGE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/bridge=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder messagingBroadcastGroupEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Broadcast Group</h1><p>{{metadata118.getDescription().getDescription()}}</p>"))
                    .rememberAs("html349")
                .end()
                .add(broadcastGroupTable)
                .add(broadcastGroupForm)
            .end();
        Element messagingBroadcastGroupEntryElement = messagingBroadcastGroupEntryBuilder.build();
        handlebarElements.put("html349", messagingBroadcastGroupEntryBuilder.referenceFor("html349"));
        navigation.addPrimary("messaging-broadcast-group-entry", "Broadcast Group", "fa fa-video-camera", messagingBroadcastGroupEntryElement);
        Elements.Builder messagingDiscoveryGroupEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>{{metadata119.getDescription().getDescription()}}</p>"))
                    .rememberAs("html352")
                .end()
                .add(discoveryGroupTable)
                .add(discoveryGroupForm)
            .end();
        Element messagingDiscoveryGroupEntryElement = messagingDiscoveryGroupEntryBuilder.build();
        handlebarElements.put("html352", messagingDiscoveryGroupEntryBuilder.referenceFor("html352"));
        navigation.addPrimary("messaging-discovery-group-entry", "Discovery Group", "fa fa-map-o", messagingDiscoveryGroupEntryElement);
        Elements.Builder messagingClusterConnectionEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>{{metadata120.getDescription().getDescription()}}</p>"))
                    .rememberAs("html355")
                .end()
                .add(clusterConnectionTable)
                .add(clusterConnectionForm)
            .end();
        Element messagingClusterConnectionEntryElement = messagingClusterConnectionEntryBuilder.build();
        handlebarElements.put("html355", messagingClusterConnectionEntryBuilder.referenceFor("html355"));
        navigation.addPrimary("messaging-cluster-connection-entry", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionEntryElement);
        Elements.Builder messagingGroupingHandlerEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>{{metadata121.getDescription().getDescription()}}</p>"))
                    .rememberAs("html358")
                .end()
                .add(groupingHandlerTable)
                .add(groupingHandlerForm)
            .end();
        Element messagingGroupingHandlerEntryElement = messagingGroupingHandlerEntryBuilder.build();
        handlebarElements.put("html358", messagingGroupingHandlerEntryBuilder.referenceFor("html358"));
        navigation.addPrimary("messaging-grouping-handler-entry", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerEntryElement);
        Elements.Builder messagingBridgeEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bridge</h1><p>{{metadata122.getDescription().getDescription()}}</p>"))
                    .rememberAs("html361")
                .end()
                .add(bridgeTable)
                .add(bridgeForm)
            .end();
        Element messagingBridgeEntryElement = messagingBridgeEntryBuilder.build();
        handlebarElements.put("html361", messagingBridgeEntryBuilder.referenceFor("html361"));
        navigation.addPrimary("messaging-bridge-entry", "Bridge", "fa fa-road", messagingBridgeEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(broadcastGroupTable);
        registerAttachable(broadcastGroupForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);
        registerAttachable(bridgeTable);
        registerAttachable(bridgeForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            broadcastGroupTable.bindForm(broadcastGroupForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);
            bridgeTable.bindForm(bridgeForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html349"), "{{metadata118.getDescription().getDescription()}}", String.valueOf(metadata118.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html352"), "{{metadata119.getDescription().getDescription()}}", String.valueOf(metadata119.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html355"), "{{metadata120.getDescription().getDescription()}}", String.valueOf(metadata120.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html358"), "{{metadata121.getDescription().getDescription()}}", String.valueOf(metadata121.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html361"), "{{metadata122.getDescription().getDescription()}}", String.valueOf(metadata122.getDescription().getDescription()));
    }
}
