package org.jboss.hal.client.configuration.subsystem.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_TransactionView extends TransactionView {

    private final Metadata metadata172;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_TransactionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata172Template = AddressTemplate.of("/{selected.profile}/subsystem=transactions");
        this.metadata172 = mbuiContext.metadataRegistry().lookup(metadata172Template);
        this.handlebarElements = new HashMap<>();

        attributesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-attributes-form", metadata172)
            .include("default-timeout", "enable-tsm-status", "journal-store-enable-async-io", "jts", "node-identifier", "statistics-enabled", "use-journal-store")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Transaction Manager", metadata172Template.resolve(mbuiContext.statementContext()), changedValues, metadata172))
            .prepareReset(form -> resetSingletonForm("Transaction Manager", metadata172Template.resolve(mbuiContext.statementContext()), form, metadata172))
            .build();
        processForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-process-form", metadata172)
            .include("process-id-uuid", "process-id-socket-binding", "process-id-socket-max-ports")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveProcessForm(form, changedValues))
            .prepareReset(form -> presenter.resetProcessForm(form))
            .build();
        processForm.getFormItem("process-id-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-recovery-form", metadata172)
            .include("socket-binding", "status-socket-binding", "recovery-listener")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Recovery", metadata172Template.resolve(mbuiContext.statementContext()), changedValues, metadata172))
            .prepareReset(form -> resetSingletonForm("Recovery", metadata172Template.resolve(mbuiContext.statementContext()), form, metadata172))
            .build();
        recoveryForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm.getFormItem("status-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        pathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-path-form", metadata172)
            .include("object-store-path", "object-store-relative-to")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Path", metadata172Template.resolve(mbuiContext.statementContext()), changedValues, metadata172))
            .prepareReset(form -> resetSingletonForm("Path", metadata172Template.resolve(mbuiContext.statementContext()), form, metadata172))
            .build();
        pathForm.getFormItem("object-store-relative-to").registerSuggestHandler(new org.jboss.hal.client.configuration.PathsAutoComplete());
        jdbcForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-jdbc-form", metadata172)
            .include("use-jdbc-store", "jdbc-action-store-drop-table", "jdbc-action-store-table-prefix", "jdbc-communication-store-drop-table", "jdbc-communication-store-table-prefix", "jdbc-state-store-drop-table", "jdbc-state-store-table-prefix", "jdbc-store-datasource")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("JDBC", metadata172Template.resolve(mbuiContext.statementContext()), changedValues, metadata172))
            .prepareReset(form -> resetSingletonForm("JDBC", metadata172Template.resolve(mbuiContext.statementContext()), form, metadata172))
            .build();
        List<AddressTemplate> jdbcFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        jdbcForm.getFormItem("jdbc-store-datasource").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), jdbcFormTemplates));


        navigation = new VerticalNavigation();
        Elements.Builder txAttributesConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Transaction Manager</h1><p>{{metadata172.getDescription().getDescription()}}</p>"))
                    .rememberAs("html503")
                .end()
                .add(attributesForm)
            .end();
        Element txAttributesConfigItemElement = txAttributesConfigItemBuilder.build();
        handlebarElements.put("html503", txAttributesConfigItemBuilder.referenceFor("html503"));
        navigation.addPrimary("tx-attributes-config-item", "Configuration", "pficon pficon-settings", txAttributesConfigItemElement);
        Elements.Builder txProcessItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process ID</h1><p>{{metadata172.getDescription().getDescription()}}</p>"))
                    .rememberAs("html505")
                .end()
                .add(processForm)
            .end();
        Element txProcessItemElement = txProcessItemBuilder.build();
        handlebarElements.put("html505", txProcessItemBuilder.referenceFor("html505"));
        navigation.addPrimary("tx-process-item", "Process", "pficon pficon-service", txProcessItemElement);
        Elements.Builder txRecoveryConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Recovery</h1><p>{{metadata172.getDescription().getDescription()}}</p>"))
                    .rememberAs("html507")
                .end()
                .add(recoveryForm)
            .end();
        Element txRecoveryConfigItemElement = txRecoveryConfigItemBuilder.build();
        handlebarElements.put("html507", txRecoveryConfigItemBuilder.referenceFor("html507"));
        navigation.addPrimary("tx-recovery-config-item", "Recovery", "fa fa-repeat", txRecoveryConfigItemElement);
        Elements.Builder txPathConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Path</h1><p>{{metadata172.getDescription().getDescription()}}</p>"))
                    .rememberAs("html509")
                .end()
                .add(pathForm)
            .end();
        Element txPathConfigItemElement = txPathConfigItemBuilder.build();
        handlebarElements.put("html509", txPathConfigItemBuilder.referenceFor("html509"));
        navigation.addPrimary("tx-path-config-item", "Path", "fa fa-folder-open", txPathConfigItemElement);
        Elements.Builder txJdbcConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC</h1><p>{{metadata172.getDescription().getDescription()}}</p>"))
                    .rememberAs("html511")
                .end()
                .add(jdbcForm)
            .end();
        Element txJdbcConfigItemElement = txJdbcConfigItemBuilder.build();
        handlebarElements.put("html511", txJdbcConfigItemBuilder.referenceFor("html511"));
        navigation.addPrimary("tx-jdbc-config-item", "JDBC", "fa fa-database", txJdbcConfigItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(attributesForm);
        registerAttachable(processForm);
        registerAttachable(recoveryForm);
        registerAttachable(pathForm);
        registerAttachable(jdbcForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html503"), "{{metadata172.getDescription().getDescription()}}", String.valueOf(metadata172.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html505"), "{{metadata172.getDescription().getDescription()}}", String.valueOf(metadata172.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html507"), "{{metadata172.getDescription().getDescription()}}", String.valueOf(metadata172.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html509"), "{{metadata172.getDescription().getDescription()}}", String.valueOf(metadata172.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html511"), "{{metadata172.getDescription().getDescription()}}", String.valueOf(metadata172.getDescription().getDescription()));
    }
}
