/**
 * Represents a DMR operation.
 */
class Operation {

    /**
     * @return {string} the name of the operation
     */
    get name() {}

    /**
     * @return {ResourceAddress} the address of the operation
     */
    get address() {}

    /**
     * @return {ModelNode} the parameters of the operation
     */
    get parameter() {}

    /**
     * @return {ModelNode} the header of the operation
     */
    get header() {}

    /**
     * @return {string} the string representation of the operation as used in the CLI
     */
    toString() {}

    /**
     * @return {string} the string representation of the operation as used in the CLI
     */
    asCli() {}
}

/**
 * Represents a composite operation consisting of n {@link Operation}s.
 */
class Composite {

    /**
     * @return {boolean} whether this composite contains operations
     */
    get empty() {}

    /**
     * @return {number} the number of operations
     */
    get size() {}

    /**
     * @return {Operation[]} the operations of this composite
     */
    get operations() {}

    /**
     * Adds the specified operation to this composite.
     * 
     * @param {Operation} operation The operation to add.
     * 
     * @return {Composite} this composite
     */
    addOperation(operation) {}

    /**
     * @return {string} a string representation of this composite
     */
    toString() {}

    /**
     * @return {string} the string representation of the operation as used in the CLI
     */
    asCli() {}
}

/**
 * Static helper methods for dealing with {@link ModelNode}s and {@link NamedNode}s. Some methods accept a path
 * parameter separated by "/" to get a deeply nested data.
 */
class ModelNodeHelper {

    /**
     * Tries to get a deeply nested model node from the specified model node. Nested paths must be separated with "/".
     * 
     * @param {ModelNode} modelNode The model node to read from
     * @param {string} path      A path separated with "/"
     * 
     * @return {ModelNode} The nested node or an empty / undefined model node
     */
    static failSafeGet(modelNode, path) {}

    /**
     * Tries to get a deeply nested boolean value from the specified model node. Nested paths must be separated with
     * "/".
     * 
     * @param {ModelNode} modelNode The model node to read from
     * @param {string} path      A path separated with "/"
     * 
     * @return {boolean} the boolean value or false.
     */
    static failSafeBoolean(modelNode, path) {}

    /**
     * Given a model as
     * <pre>
     * {
     * other-attr: "value1"
     * complexAttr-name1: "some value 1",
     * complexAttr-name2: "some value 2"
     * }
     * </pre>
     * This method extracts the complex attribute name and adds the nested attributes into the complex attribute.
     * If createComplexAttribute=true, the resulting model node is:
     * 
     * <pre>
     * {
     * other-attr: "value1"
     * complexAttr: {
     * name1: "some value 1",
     * name2: "some value 2"
     * }
     * }
     * </pre>
     * 
     * If createComplexAttribute=false, the resulting model node is:
     * 
     * <pre>
     * {
     * other-attr: "value1"
     * name1: "some value 1",
     * name2: "some value 2"
     * }
     * </pre>
     * 
     * @param {string} complexAttributeName The complex attribute name
     * @param {ModelNode} model The model
     * @param {boolean} createComplexAttribute Control if the resulting model should add the complex attribute name, see above example.
     */
    static reassembleComplexAttribute(complexAttributeName, model, createComplexAttribute) {}

    /**
     * Tries to get a deeply nested node array from the specified model node. Nested paths must be separated with "/".
     * 
     * @param {ModelNode} modelNode The model node to read from
     * @param {string} path      A path separated with "/"
     * 
     * @return {ModelNode[]} the model nodes or an empty array
     */
    static failSafeList(modelNode, path) {}

    /**
     * Tries to get a deeply nested property array from the specified model node. Nested paths must be separated with
     * "/".
     * 
     * @param {ModelNode} modelNode The model node to read from
     * @param {string} path      A path separated with "/"
     * 
     * @return {Property[]} the properties or an empty array
     */
    static failSafePropertyList(modelNode, path) {}

    /**
     * Turns an properties array into an array of names nodes.
     * 
     * @param {Property[]} properties The properties
     * 
     * @return {NamedNode[]} the array of named nodes
     */
    static asNamedNodes(properties) {}
}

/**
 * A model node with a name.
 */
class NamedNode {

    /**
     * @return {string} the name of this named node
     */
    get name() {}

    /**
     * @return {ModelNode} the model node of this named node
     */
    get modelNode() {}

    /**
     * @return {string} a string representation of this model node
     */
    toString() {}

    
    setName(name) {}

    
    update(node) {}

    
    static create(name) {}
}

/**
 * Represents a fully qualified DMR address ready to be put into a DMR operation. The address consists of 0-n segments
 * with a name and a value for each segment.
 */
class ResourceAddress {

    /**
     * @return {string} the value of the first segment or null if this address is empty.
     */
    get firstValue() {}

    /**
     * @return {string} the name of the last segment or null if this address is empty.
     */
    get lastName() {}

    /**
     * @return {string} the value of the last segment or null if this address is empty.
     */
    get lastValue() {}

    /**
     * @return {ResourceAddress} the parent address or the root address if this address has no parent.
     */
    get parent() {}

    /**
     * @return {number} the number of segments.
     */
    get size() {}

    /**
     * @return {boolean} whether this address is empty.
     */
    get empty() {}

    /**
     * @return {ResourceAddress} the empty (root) address
     */
    static root() {}

    /**
     * Adds the specified segment to this address.
     * 
     * @param {string} propertyName  the property name
     * @param {string} propertyValue the property value
     * 
     * @return {ResourceAddress} this address with the specified segment added
     */
    addSegment(propertyName, propertyValue) {}

    /**
     * Adds the specified address to this address.
     * 
     * @param {ResourceAddress} address The address to add.
     * 
     * @return {ResourceAddress} this address with the specified address added
     */
    addAddress(address) {}

    /**
     * Replaces the value in the specified segment
     * 
     * @param {string} name     The name of the segment.
     * @param {string} newValue The new value.
     * 
     * @return {ResourceAddress} this address containing the replaced value
     */
    replaceValue(name, newValue) {}

    /**
     * @return {string} the address as string
     */
    toString() {}
}

/**
 * Represents the result of a composite operation.
 */
class CompositeResult {

    /**
     * @return {number} the number of steps
     */
    get size() {}

    /**
     * @return {boolean} whether this composite result contains steps
     */
    get empty() {}

    /**
     * @return {ModelNode[]} the steps of this composite result
     */
    get steps() {}

    /**
     * @param {string} step Step as "step-n" (one-based!)
     * 
     * @return {ModelNode} the related step result
     */
    step(step) {}
}

/**
 * Executes operations against the management endpoint.
 */
class Dispatcher {

    /**
     * Executes the specified composite operation.
     * 
     * @param {Composite} composite The composite operation to execute.
     * @param {function(result: CompositeResult)} callback  The callback receiving the result.
     */
    executeComposite(composite, callback) {}

    /**
     * Executes the specified operation. The callback contains just the result w/o surrounding nodes like "outcome".
     * 
     * @param {Operation} operation The operation to execute.
     * @param {function(result: ModelNode)} callback  The callback receiving the result.
     */
    execute(operation, callback) {}
}

/**
 * A dynamic model representation node object.
 */
class ModelNode {

    /**
     * Determine whether this node is defined.
     * 
     * @return {boolean} true if this node's value is defined, false otherwise
     */
    get defined() {}

    /**
     * @return {boolean} true if this node has an outcome and the outcome does not equal "success"
     */
    get failure() {}

    /**
     * @return {string} the failure description or "No failure-description provided"
     */
    get failureDescription() {}

    /**
     * Creates a new node from a base64 encoded string
     * 
     * @param {string} encoded The base64 encoded string.
     * 
     * @return {ModelNode} the new model node
     */
    static fromBase64(encoded) {}

    /**
     * Get the value of this node as number. Collection types will return the size
     * of the collection for this value. Other types may attempt a string conversion.
     * 
     * @return {number} the numeric value
     * 
     * @throws IllegalArgumentException if no conversion is possible
     */
    asInt() {}

    /**
     * Get the value of this node as a boolean. Collection types return true for non-empty collections. Numerical types
     * return true for non-zero values.
     * 
     * @return {boolean} the boolean value
     * 
     * @throws IllegalArgumentException if no conversion is possible
     */
    asBoolean() {}

    /**
     * Get the value as a string. This is the literal value of this model node. More than one node type may
     * yield the same value for this method.
     * 
     * @return {string} the string value
     */
    asString() {}

    /**
     * Get the value of this node as a property. Object values will return a property if there is exactly one
     * property in the object. List values will return a property if there are exactly two items in the list,
     * and if the first is convertible to a string.
     * 
     * @return {Property} the property value
     * 
     * @throws IllegalArgumentException if no conversion is possible
     */
    asProperty() {}

    /**
     * Get a copy of this value as an object. Object values will simply copy themselves.
     * <p>
     * Property values will return a single-entry object whose key and value are copied from the property key and value.
     * <p>
     * List values will attempt to interpolate the list into an object by iterating each item, mapping each property
     * into an object entry and otherwise taking pairs of list entries, converting the first to a string, and using the
     * pair of entries as a single object entry. If an object key appears more than once in the source object, the
     * last key takes precedence.
     * 
     * @return {ModelNode} the object value
     * 
     * @throws IllegalArgumentException if no conversion is possible
     */
    asObject() {}

    /**
     * Change this node's value to the given value.
     * 
     * @param {number} newValue the new value
     * 
     * @return {ModelNode} this node
     */
    setNumber(newValue) {}

    /**
     * Change this node's value to the given value.
     * 
     * @param {boolean} newValue the new value
     * 
     * @return {ModelNode} this node
     */
    setBoolean(newValue) {}

    /**
     * Change this node's value to the given expression value.
     * 
     * @param {string} newValue the new value
     * 
     * @return {ModelNode} this node
     */
    setExpression(newValue) {}

    /**
     * Change this node's value to the given value.
     * 
     * @param {string} newValue the new value
     * 
     * @return {ModelNode} this node
     */
    setString(newValue) {}

    /**
     * Change this node's value to the given value. The value is copied from the parameter.
     * 
     * @param {ModelNode} newValue the new value
     * 
     * @return {ModelNode} this node
     */
    setNode(newValue) {}

    /**
     * Change this node's value to the given value.
     * 
     * @param {Property} newValue the new value
     * 
     * @return {ModelNode} this node
     */
    setProperty(newValue) {}

    /**
     * Change this node's value to an empty list.
     * 
     * @return {ModelNode} this node
     */
    setEmptyList() {}

    /**
     * Change this node's value to an empty object.
     * 
     * @return {ModelNode} this node
     */
    setEmptyObject() {}

    /**
     * Clear this node's value and change its type to undefined.
     * 
     * @return {ModelNode} this node
     */
    clear() {}

    /**
     * Get the child of this node with the given name. If no such child exists, create it. If the node is undefined,
     * it will be initialized to be of type object.
     * <p>
     * When called on property values, the name must match the property name.
     * 
     * @param {string} name the child name
     * 
     * @return {ModelNode} the child
     * 
     * @throws IllegalArgumentException if this node does not support getting a child with the given name
     */
    get(name) {}

    /**
     * Add a node to the end of this node's value list and return it. If the node is undefined, it will be initialized
     * to be of type list.
     * 
     * @return {ModelNode} the new node
     */
    add() {}

    /**
     * Determine whether this node has a child with the given name. Property node types always contain exactly one
     * value with a key equal to the property name.
     * 
     * @param {string} key the name
     * 
     * @return {boolean} true if there is a (possibly undefined) node at the given key
     */
    has(key) {}

    /**
     * Determine whether this node has a defined child with the given name. Property node types always contain exactly
     * one value with a key equal to the property name.
     * 
     * @param {string} key the name
     * 
     * @return {boolean} true if there is a node at the given index and its type is not undefined
     */
    hasDefined(key) {}

    /**
     * Get a human-readable string representation of this model node, formatted nicely (possibly on multiple lines).
     * 
     * @return {string} the string representation
     */
    toString() {}

    
    toBase64String() {}

    /**
     * Creates a new undefined model node
     * @return {ModelNode} the new model node
     */
    static create() {}

    /**
     * @return {json} the model node as JSON
     */
    getJSON() {}

    /**
     * @return {Property[]} this model node as an {@link Property} array
     */
    asProperties() {}

    /**
     * @return {ModelNode[]} this model node as an array.
     */
    asList() {}
}

/**
 * A builder for operations.
 */
class OperationBuilder {

    /**
     * Uses the specified payload for the operation.
     * 
     * @param {ModelNode} payload The operation as model node.
     * 
     * @return {OperationBuilder} this builder
     */
    payload(payload) {}

    /**
     * @return {Operation} builds and returns the operation
     */
    build() {}

    /**
     * Add a parameter to the operation
     * 
     * @param {string} name  The name of the parameter.
     * @param {boolean|int|string} value The value of the parameter.
     * 
     * @return {OperationBuilder} this builder
     */
    param(name, value) {}

    /**
     * Add a header to the operation
     * 
     * @param {string} name  The name of the header.
     * @param {boolean|int|string} value The value of the header.
     * 
     * @return {OperationBuilder} this builder
     */
    header(name, value) {}
}

/**
 * Represents a DMR property.
 */
class Property {

    /**
     * Creates a new property
     * 
     * @param {string} name  The name of the property.
     * @param {ModelNode} value The value of the property.
     */
    constructor(name, value) {}

    /**
     * @return {string} the name of the property
     */
    get name() {}

    /**
     * @return {ModelNode} the value of the property
     */
    get value() {}
}

