/**
 * Represents the RBAC related payload from the read-resource-description operation.
 */
class SecurityContext {

    /**
     * A security context with hardcoded permissions to read resources, write and execute operations are not allowed.
     */
    static get READ_ONLY() {}

    /**
     * A security context with hardcoded permissions to read, write and execute any resource.
     */
    static get RWX() {}

    /**
     * @return {boolean} whether the security context is readable
     */
    get readable() {}

    /**
     * @return {boolean} whether the security context is writable
     */
    get writable() {}

    /**
     * @param {string} attribute The attribute to check.
     * 
     * @return {boolean} whether the attribute is readable
     */
    isReadable(attribute) {}

    /**
     * @param {string} attribute The attribute to check.
     * 
     * @return {boolean} whether the attribute is writable
     */
    isWritable(attribute) {}

    /**
     * @param {string} operation The operation to check.
     * 
     * @return {boolean} whether the operation is executable
     */
    isExecutable(operation) {}
}

/**
 * Template for a DMR address which might contain multiple variable parts.
 * 
 * An address template can be defined using the following BNF:
 * <pre>
 * &lt;address template&gt; ::= "/" | &lt;segment&gt;
 * &lt;segment&gt;          ::= &lt;tuple&gt; | &lt;segment&gt;"/"&lt;tuple&gt;
 * &lt;tuple&gt;            ::= &lt;variable&gt; | &lt;key&gt;"="&lt;value&gt;
 * &lt;variable&gt;         ::= "{"&lt;alpha&gt;"}"
 * &lt;key&gt;              ::= &lt;alpha&gt;
 * &lt;value&gt;            ::= &lt;variable&gt; | &lt;alpha&gt; | "*"
 * &lt;alpha&gt;            ::= &lt;upper&gt; | &lt;lower&gt;
 * &lt;upper&gt;            ::= "A" | "B" | … | "Z"
 * &lt;lower&gt;            ::= "a" | "b" | … | "z"
 * </pre>
 * 
 * Following variables are supported:
 * - <code>{domain.controller}</code>
 * - <code>{selected.profile}</code>
 * - <code>{selected.group}</code>
 * - <code>{selected.server-config}</code>
 * - <code>{selected.server}</code>
 * 
 * To get a fully qualified address from an address template use the method <code>resolve()</code>. For standalone mode
 * the variables will resolve to an empty string. The values of the variables are managed by the {@link
 * StatementContext}.
 * 
 * @example AddressTemplate a2 = AddressTemplate.of("{selected.profile}");
 * AddressTemplate a3 = AddressTemplate.of("{selected.profile}/subsystem=mail");
 * AddressTemplate a4 = AddressTemplate.of("{selected.profile}/subsystem=mail/mail-session=*");
 */
class AddressTemplate {

    /**
     * The root template
     */
    static get ROOT() {}

    /**
     * @return {boolean} true if this template contains no tokens, false otherwise
     */
    get empty() {}

    /**
     * @return {number} the number of tokens
     */
    get size() {}

    /**
     * @return {AddressTemplate} the parent address template or the root template
     */
    get parent() {}

    /**
     * @return {string} the name of the first segment or null if this address template is empty.
     */
    get firstName() {}

    /**
     * @return {string} the value of the first segment or null if this address template is empty.
     */
    get firstValue() {}

    /**
     * @return {string} the name of the last segment or null if this address template is empty.
     */
    get lastName() {}

    /**
     * @return {string} the value of the last segment or null if this address template is empty.
     */
    get lastValue() {}

    /**
     * Creates a new address template from an encoded string template.
     */
    static of(template) {}

    /**
     * @return {string} the string representation of this address template
     */
    toString() {}

    /**
     * Resolve this address template against the specified statement context.
     * 
     * @param {StatementContext} context   the statement context
     * @param {...string} wildcards An optional list of wildcards which are used to resolve any wildcards in this address template
     * from left to right
     * 
     * @return {ResourceAddress} a fully qualified resource address which might be empty, but which does not contain any tokens
     */
    resolve(context, wildcards) {}

    /**
     * Append an address to this addrress template and return a new one.
     * 
     * @param {string|AddressTemplate} address The address to append.
     * 
     * @return {AddressTemplate} a new address template with the specified address added at the end.
     */
    append(address) {}
}

/**
 * Simple data struct for common metadata. Used to keep the method signatures small and tidy.
 */
class Metadata {

    /**
     * @return {AddressTemplate} the address template
     */
    get template() {}

    /**
     * @return {SecurityContext} the security context
     */
    get securityContext() {}

    /**
     * @return {ResourceDescription} the resource description
     */
    get description() {}
}

/**
 * Reads resource {@link Metadata} using read-resource-description operations and stores it into the {@link
 * MetadataRegistry}. If you're sure the metadata is present you can use the {@link MetadataRegistry} instead.
 */
class MetadataProcessor {

    /**
     * Reads the metadata for the template, stores it in the registry and passes it to the callback. If the metadata is
     * already in the registry it's passed directly to the callback.
     * 
     * @param {AddressTemplate|String} template The address template to lookup.
     * @param {function(metadata: Metadata)} callback The callback which receives the metadata.
     */
    lookup(template, callback) {}
}

/**
 * Contains the resource and attribute descriptions from the read-resource-description operation.
 */
class ResourceDescription {

    /**
     * @return {string} the resource description
     */
    get description() {}

    /**
     * @return {Property[]} the operation descriptions
     */
    get operations() {}

    /**
     * @return {Property[]} the attribute descriptions
     */
    getAttributes() {}

    /**
     * @return {Property[]} the request properties of the add operation
     */
    getRequestProperties() {}
}

/**
 * Contains global state which is updated as you navigate in the console. In standalone mode most of the methods return
 * null.
 */
class StatementContext {

    /**
     * @return {string} the domain controller
     */
    get domainController() {}

    /**
     * @return {string} the selected profile
     */
    get selectedProfile() {}

    /**
     * @return {string} the selected server group
     */
    get selectedServerGroup() {}

    /**
     * @return {string} the selected host
     */
    get selectedHost() {}

    /**
     * @return {string} the selected server config
     */
    get selectedServerConfig() {}

    /**
     * @return {string} the selected server
     */
    get selectedServer() {}
}

/**
 * Registry for existing resource {@link Metadata}.
 */
class MetadataRegistry {

    /**
     * Checks whether there's a metadata for the specified template.
     * 
     * @param {AddressTemplate|String} template The address template to check.
     * 
     * @return {boolean} true if the registry contains metadata for the given template, false otherwise
     */
    contains(template) {}

    /**
     * Returns metadata associated with the specified address template.
     * 
     * @param {AddressTemplate|String} template The address template to lookup.
     * 
     * @return {Metadata} the metadata for the specified template
     * 
     * @throws MissingMetadataException if no metadata for the given template exists
     */
    lookup(template) {}
}

