package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SocketBindingGroupView extends SocketBindingGroupView {

    private final Metadata metadata4;
    private final Metadata metadata3;
    private final Metadata metadata2;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SocketBindingGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata4Template = AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata3Template = AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*");
        this.metadata3 = mbuiContext.metadataRegistry().lookup(metadata3Template);
        AddressTemplate metadata2Template = AddressTemplate.of("/socket-binding-group=*");
        this.metadata2 = mbuiContext.metadataRegistry().lookup(metadata2Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-configuration-form", metadata2)
            .include("default-interface", "includes")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBindingGroup(changedValues))
            .prepareReset(form -> presenter.resetSocketBindingGroup(form))
            .build();
        outboundLocalForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-form", metadata3)
            .include("socket-binding-ref", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_LOCAL, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_LOCAL, form))
            .build();
        outboundLocalForm.getFormItem("socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        outboundRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-form", metadata4)
            .include("host", "port", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_REMOTE, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_REMOTE, form))
            .build();

        outboundLocalTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-table", metadata3)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_LOCAL), Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_LOCAL, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundRemoteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-table", metadata4)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_REMOTE), Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_REMOTE, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("host", (cell, type, row, meta) -> row.get("host").asString())
            .column("port", (cell, type, row, meta) -> row.get("port").asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html5;
        HTMLElement socketBindingGroupConfigurationItemElement = section()
            .add(html5 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Group</h1><p>{{metadata2.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        handlebarElements.put("html5", html5);
        navigation.addPrimary("socket-binding-group-configuration-item", "Configuration", "pficon pficon-settings", socketBindingGroupConfigurationItemElement);
        HTMLElement html7;
        HTMLElement socketBindingGroupOutboundLocalItemElement = section()
            .add(html7 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Local</h1><p>{{metadata3.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(outboundLocalTable)
            .add(outboundLocalForm)
            .asElement();
        handlebarElements.put("html7", html7);
        navigation.addPrimary("socket-binding-group-outbound-local-item", "Outbound Local", "fa fa-arrow-circle-o-right", socketBindingGroupOutboundLocalItemElement);
        HTMLElement html10;
        HTMLElement socketBindingGroupOutboundRemoteItemElement = section()
            .add(html10 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Remote</h1><p>{{metadata4.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(outboundRemoteTable)
            .add(outboundRemoteForm)
            .asElement();
        handlebarElements.put("html10", html10);
        navigation.addPrimary("socket-binding-group-outbound-remote-item", "Outbound Remote", "fa fa-arrow-circle-right", socketBindingGroupOutboundRemoteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(outboundLocalTable);
        registerAttachable(outboundLocalForm);
        registerAttachable(outboundRemoteTable);
        registerAttachable(outboundRemoteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            outboundLocalTable.bindForm(outboundLocalForm);
            outboundRemoteTable.bindForm(outboundRemoteForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html5"), "{{metadata2.getDescription().getDescription()}}", String.valueOf(metadata2.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html7"), "{{metadata3.getDescription().getDescription()}}", String.valueOf(metadata3.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html10"), "{{metadata4.getDescription().getDescription()}}", String.valueOf(metadata4.getDescription().getDescription()));
    }
}
