package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata73;
    private final Metadata metadata69;
    private final Metadata metadata71;
    private final Metadata metadata72;
    private final Metadata metadata70;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/bridge=*");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        AddressTemplate metadata69Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*");
        this.metadata69 = mbuiContext.metadataRegistry().lookup(metadata69Template);
        AddressTemplate metadata71Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata71 = mbuiContext.metadataRegistry().lookup(metadata71Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata70Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*");
        this.metadata70 = mbuiContext.metadataRegistry().lookup(metadata70Template);
        this.handlebarElements = new HashMap<>();

        broadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-form", metadata69)
            .include("broadcast-period", "connectors", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BROADCAST_GROUP, form))
            .build();
        broadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-form", metadata70)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DISCOVERY_GROUP, form))
            .build();
        discoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-form", metadata71)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-form", metadata72)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();
        bridgeForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-bridge-form", metadata73)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BRIDGE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BRIDGE, form))
            .build();

        broadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-table", metadata69)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-table", metadata70)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        clusterConnectionTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-table", metadata71)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        groupingHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-table", metadata72)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.GROUPING_HANDLER), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.GROUPING_HANDLER, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        bridgeTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-bridge-table", metadata73)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addBridge(ServerSubResource.BRIDGE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/bridge=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.BRIDGE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/bridge=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html199;
        HTMLElement messagingBroadcastGroupEntryElement = section()
            .add(html199 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Broadcast Group</h1><p>{{metadata69.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(broadcastGroupTable)
            .add(broadcastGroupForm)
            .asElement();
        handlebarElements.put("html199", html199);
        navigation.addPrimary("messaging-broadcast-group-entry", "Broadcast Group", "fa fa-video-camera", messagingBroadcastGroupEntryElement);
        HTMLElement html202;
        HTMLElement messagingDiscoveryGroupEntryElement = section()
            .add(html202 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>{{metadata70.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
            .asElement();
        handlebarElements.put("html202", html202);
        navigation.addPrimary("messaging-discovery-group-entry", "Discovery Group", "fa fa-map-o", messagingDiscoveryGroupEntryElement);
        HTMLElement html205;
        HTMLElement messagingClusterConnectionEntryElement = section()
            .add(html205 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>{{metadata71.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(clusterConnectionTable)
            .add(clusterConnectionForm)
            .asElement();
        handlebarElements.put("html205", html205);
        navigation.addPrimary("messaging-cluster-connection-entry", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionEntryElement);
        HTMLElement html208;
        HTMLElement messagingGroupingHandlerEntryElement = section()
            .add(html208 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>{{metadata72.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(groupingHandlerTable)
            .add(groupingHandlerForm)
            .asElement();
        handlebarElements.put("html208", html208);
        navigation.addPrimary("messaging-grouping-handler-entry", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerEntryElement);
        HTMLElement html211;
        HTMLElement messagingBridgeEntryElement = section()
            .add(html211 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bridge</h1><p>{{metadata73.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(bridgeTable)
            .add(bridgeForm)
            .asElement();
        handlebarElements.put("html211", html211);
        navigation.addPrimary("messaging-bridge-entry", "Bridge", "fa fa-road", messagingBridgeEntryElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(broadcastGroupTable);
        registerAttachable(broadcastGroupForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);
        registerAttachable(bridgeTable);
        registerAttachable(bridgeForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            broadcastGroupTable.bindForm(broadcastGroupForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);
            bridgeTable.bindForm(bridgeForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html199"), "{{metadata69.getDescription().getDescription()}}", String.valueOf(metadata69.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html202"), "{{metadata70.getDescription().getDescription()}}", String.valueOf(metadata70.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html205"), "{{metadata71.getDescription().getDescription()}}", String.valueOf(metadata71.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html208"), "{{metadata72.getDescription().getDescription()}}", String.valueOf(metadata72.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html211"), "{{metadata73.getDescription().getDescription()}}", String.valueOf(metadata73.getDescription().getDescription()));
    }
}
