package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata103;
    private final Metadata metadata101;
    private final Metadata metadata100;
    private final Metadata metadata99;
    private final Metadata metadata102;
    private final Metadata metadata104;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/configuration=endpoint");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata104Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata104 = mbuiContext.metadataRegistry().lookup(metadata104Template);
        this.handlebarElements = new HashMap<>();

        endpointConfigurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-endpoint-configuration", metadata99)
            .customGroup("remoting-endpoint-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-endpoint-configuration-security", mbuiContext.resources().constants().security())
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-endpoint-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Endpoint Configuration", metadata99Template.resolve(mbuiContext.statementContext()), changedValues, metadata99))
            .prepareReset(form -> resetSingletonForm("Endpoint Configuration", metadata99Template.resolve(mbuiContext.statementContext()), form, metadata99))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-form", metadata102)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetLocalOutbound(form))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-form", metadata103)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetOutbound(form))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-form", metadata104)
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 1)
            .include("protocol")
            .include("security-realm")
            .include("username")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetRemoteOutbound(form))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-connector-table", metadata100)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD_SUFFIX), "Connector",
                metadata100Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata100Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-http-connector-table", metadata101)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD_SUFFIX), "HTTP Connector",
                metadata101Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata101Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        localOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-table", metadata102)
            .button(mbuiContext.tableButtonFactory().add(metadata102Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata102,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata102Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata102Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-table", metadata103)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD_SUFFIX), "Outbound",
                metadata103Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata103Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-table", metadata104)
            .button(mbuiContext.tableButtonFactory().add(metadata104Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata104,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata104Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata104Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html285;
        HTMLElement remotingEndpointConfigurationItemElement = section()
            .add(html285 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Endpoint Configuration</h1><p>{{metadata99.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(endpointConfigurationForm)
            .asElement();
        handlebarElements.put("html285", html285);
        navigation.addPrimary("remoting-endpoint-configuration-item", "Endpoint Configuration", "pficon pficon-settings", remotingEndpointConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        HTMLElement html287;
        HTMLElement remotingConnectorSubItemElement = section()
            .add(html287 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>{{metadata100.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(connectorTable)
            .asElement();
        handlebarElements.put("html287", html287);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        HTMLElement html289;
        HTMLElement remotingHttpConnectorSubItemElement = section()
            .add(html289 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>{{metadata101.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(httpConnectorTable)
            .asElement();
        handlebarElements.put("html289", html289);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        HTMLElement html291;
        HTMLElement remotingLocalOutboundSubItemElement = section()
            .add(html291 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(localOutboundTable)
            .add(localOutboundForm)
            .asElement();
        handlebarElements.put("html291", html291);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        HTMLElement html294;
        HTMLElement remotingOutboundSubItemElement = section()
            .add(html294 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>{{metadata103.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(outboundTable)
            .add(outboundForm)
            .asElement();
        handlebarElements.put("html294", html294);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        HTMLElement html297;
        HTMLElement remotingRemoteOutboundSubItemElement = section()
            .add(html297 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>{{metadata104.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(remoteOutboundTable)
            .add(remoteOutboundForm)
            .asElement();
        handlebarElements.put("html297", html297);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(endpointConfigurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html285"), "{{metadata99.getDescription().getDescription()}}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html287"), "{{metadata100.getDescription().getDescription()}}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html289"), "{{metadata101.getDescription().getDescription()}}", String.valueOf(metadata101.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html291"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html294"), "{{metadata103.getDescription().getDescription()}}", String.valueOf(metadata103.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html297"), "{{metadata104.getDescription().getDescription()}}", String.valueOf(metadata104.getDescription().getDescription()));
    }
}
