package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata115;
    private final Metadata metadata110;
    private final Metadata metadata111;
    private final Metadata metadata114;
    private final Metadata metadata112;
    private final Metadata metadata113;
    private final Metadata metadata109;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata115Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata115 = mbuiContext.metadataRegistry().lookup(metadata115Template);
        AddressTemplate metadata110Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata110 = mbuiContext.metadataRegistry().lookup(metadata110Template);
        AddressTemplate metadata111Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata111 = mbuiContext.metadataRegistry().lookup(metadata111Template);
        AddressTemplate metadata114Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata114 = mbuiContext.metadataRegistry().lookup(metadata114Template);
        AddressTemplate metadata112Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata112 = mbuiContext.metadataRegistry().lookup(metadata112Template);
        AddressTemplate metadata113Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata113 = mbuiContext.metadataRegistry().lookup(metadata113Template);
        AddressTemplate metadata109Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata109 = mbuiContext.metadataRegistry().lookup(metadata109Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata109)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-form", metadata110)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-form", metadata111)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-form", metadata112)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-form", metadata113)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-form", metadata115)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-form", metadata114)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        authenticationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-table", metadata110)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClassicAuthenticationModule(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHENTICATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authorizationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-table", metadata111)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUTHORIZATION), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHORIZATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        auditTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-table", metadata112)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUDIT), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUDIT), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        aclTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-table", metadata113)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.ACL), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.ACL), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        trustTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-table", metadata115)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.TRUST), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.TRUST), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mappingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-table", metadata114)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.MAPPING), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.MAPPING), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html312;
        HTMLElement securityDomainConfigurationItemElement = section()
            .add(html312 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata109.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        handlebarElements.put("html312", html312);
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        HTMLElement html314;
        HTMLElement securityDomainAuthenticationItemElement = section()
            .add(html314 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>{{metadata110.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(authenticationTable)
            .add(authenticationForm)
            .asElement();
        handlebarElements.put("html314", html314);
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        HTMLElement html317;
        HTMLElement securityDomainAuthorizationItemElement = section()
            .add(html317 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>{{metadata111.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(authorizationTable)
            .add(authorizationForm)
            .asElement();
        handlebarElements.put("html317", html317);
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        HTMLElement html320;
        HTMLElement securityDomainAuditItemElement = section()
            .add(html320 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>{{metadata112.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(auditTable)
            .add(auditForm)
            .asElement();
        handlebarElements.put("html320", html320);
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        HTMLElement html323;
        HTMLElement securityDomainAclItemElement = section()
            .add(html323 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>{{metadata113.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(aclTable)
            .add(aclForm)
            .asElement();
        handlebarElements.put("html323", html323);
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        HTMLElement html326;
        HTMLElement securityDomainMappingItemElement = section()
            .add(html326 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>{{metadata114.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(mappingTable)
            .add(mappingForm)
            .asElement();
        handlebarElements.put("html326", html326);
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        HTMLElement html329;
        HTMLElement securityDomainTrustItemElement = section()
            .add(html329 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>{{metadata115.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(trustTable)
            .add(trustForm)
            .asElement();
        handlebarElements.put("html329", html329);
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html312"), "{{metadata109.getDescription().getDescription()}}", String.valueOf(metadata109.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html314"), "{{metadata110.getDescription().getDescription()}}", String.valueOf(metadata110.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html317"), "{{metadata111.getDescription().getDescription()}}", String.valueOf(metadata111.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html320"), "{{metadata112.getDescription().getDescription()}}", String.valueOf(metadata112.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html323"), "{{metadata113.getDescription().getDescription()}}", String.valueOf(metadata113.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html326"), "{{metadata114.getDescription().getDescription()}}", String.valueOf(metadata114.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html329"), "{{metadata115.getDescription().getDescription()}}", String.valueOf(metadata115.getDescription().getDescription()));
    }
}
