package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata118;
    private final Metadata metadata121;
    private final Metadata metadata119;
    private final Metadata metadata117;
    private final Metadata metadata122;
    private final Metadata metadata120;
    private final Metadata metadata116;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata118Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata118 = mbuiContext.metadataRegistry().lookup(metadata118Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata119Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata119 = mbuiContext.metadataRegistry().lookup(metadata119Template);
        AddressTemplate metadata117Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata117 = mbuiContext.metadataRegistry().lookup(metadata117Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata116Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata116 = mbuiContext.metadataRegistry().lookup(metadata116Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata116)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata116Template.resolve(mbuiContext.statementContext()), changedValues, metadata116))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata116Template.resolve(mbuiContext.statementContext()), form, metadata116))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata117)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata117Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata117);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata117Template.resolve(mbuiContext.statementContext(), name), form, metadata117);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata118)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata118Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata118);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata118Template.resolve(mbuiContext.statementContext(), name), form, metadata118);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata119)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata119Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata119);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata119Template.resolve(mbuiContext.statementContext(), name), form, metadata119);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata120)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata120Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata120);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata120Template.resolve(mbuiContext.statementContext(), name), form, metadata120);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata121)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata121Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata121);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata121Template.resolve(mbuiContext.statementContext(), name), form, metadata121);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata122)
            .singleton(
                () -> new Operation.Builder(metadata122Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata122Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata122Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata122Template.resolve(mbuiContext.statementContext()), changedValues, metadata122))
            .prepareReset(form -> resetSingletonForm("Vault", metadata122Template.resolve(mbuiContext.statementContext()), form, metadata122))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata117)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD_SUFFIX), "Elytron Key Manager",
                metadata117Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata117Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata118)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD_SUFFIX), "Elytron Key Store",
                metadata118Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata118Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata119)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD_SUFFIX), "Elytron Realm",
                metadata119Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata119Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata120)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD_SUFFIX), "Elytron Trust Manager",
                metadata120Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata120Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata121)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD_SUFFIX), "Elytron Trust Store",
                metadata121Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata121Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html333;
        HTMLElement securityConfigurationItemElement = section()
            .add(html333 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata116.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        handlebarElements.put("html333", html333);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html335;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html335 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>{{metadata117.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(keyManagerTable)
            .add(keyManagerForm)
            .asElement();
        handlebarElements.put("html335", html335);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html338;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html338 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>{{metadata118.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(keyStoreTable)
            .add(keyStoreForm)
            .asElement();
        handlebarElements.put("html338", html338);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html341;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html341 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>{{metadata119.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(realmTable)
            .add(realmForm)
            .asElement();
        handlebarElements.put("html341", html341);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html344;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html344 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>{{metadata120.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(trustManagerTable)
            .add(trustManagerForm)
            .asElement();
        handlebarElements.put("html344", html344);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html347;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html347 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>{{metadata121.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(trustStoreTable)
            .add(trustStoreForm)
            .asElement();
        handlebarElements.put("html347", html347);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html350;
        HTMLElement securityVaultItemElement = section()
            .add(html350 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>{{metadata122.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(vaultForm)
            .asElement();
        handlebarElements.put("html350", html350);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html333"), "{{metadata116.getDescription().getDescription()}}", String.valueOf(metadata116.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html335"), "{{metadata117.getDescription().getDescription()}}", String.valueOf(metadata117.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html338"), "{{metadata118.getDescription().getDescription()}}", String.valueOf(metadata118.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html341"), "{{metadata119.getDescription().getDescription()}}", String.valueOf(metadata119.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html344"), "{{metadata120.getDescription().getDescription()}}", String.valueOf(metadata120.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html347"), "{{metadata121.getDescription().getDescription()}}", String.valueOf(metadata121.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html350"), "{{metadata122.getDescription().getDescription()}}", String.valueOf(metadata122.getDescription().getDescription()));
    }
}
