package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata138;
    private final Metadata metadata137;
    private final Metadata metadata139;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata138Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata138 = mbuiContext.metadataRegistry().lookup(metadata138Template);
        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.group}");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        AddressTemplate metadata139Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata139 = mbuiContext.metadataRegistry().lookup(metadata139Template);
        this.handlebarElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata137)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata137Template.resolve(mbuiContext.statementContext()), changedValues, metadata137))
            .prepareReset(form -> resetSingletonForm("Server Group Configuration", metadata137Template.resolve(mbuiContext.statementContext()), form, metadata137))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-form", metadata138)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata138Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata138);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata138Template.resolve(mbuiContext.statementContext(), name), form, metadata138);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-form", metadata139)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata139Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata139);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata139Template.resolve(mbuiContext.statementContext(), name), form, metadata139);
            })
            .build();

        serverGroupJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-table", metadata138)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata138Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata138Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-table", metadata139)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata139Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata139Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html404;
        HTMLElement serverGroupConfigurationItemElement = section()
            .add(html404 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>{{metadata137.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverGroupConfigurationForm)
            .asElement();
        handlebarElements.put("html404", html404);
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        HTMLElement html406;
        HTMLElement serverGroupJvmItemElement = section()
            .add(html406 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata138.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverGroupJvmTable)
            .add(serverGroupJvmForm)
            .asElement();
        handlebarElements.put("html406", html406);
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        HTMLElement html409;
        HTMLElement serverGroupSystemPropertyItemElement = section()
            .add(html409 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata139.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverGroupSystemPropertyTable)
            .add(serverGroupSystemPropertyForm)
            .asElement();
        handlebarElements.put("html409", html409);
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html404"), "{{metadata137.getDescription().getDescription()}}", String.valueOf(metadata137.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html406"), "{{metadata138.getDescription().getDescription()}}", String.valueOf(metadata138.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html409"), "{{metadata139.getDescription().getDescription()}}", String.valueOf(metadata139.getDescription().getDescription()));
    }
}
