package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata140;
    private final Metadata metadata144;
    private final Metadata metadata142;
    private final Metadata metadata143;
    private final Metadata metadata141;
    private final Metadata metadata145;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata140Template = AddressTemplate.of("/{selected.host}");
        this.metadata140 = mbuiContext.metadataRegistry().lookup(metadata140Template);
        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata142Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata142 = mbuiContext.metadataRegistry().lookup(metadata142Template);
        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata145Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata145 = mbuiContext.metadataRegistry().lookup(metadata145Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata140)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata140Template.resolve(mbuiContext.statementContext()), form, metadata140))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata141)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata141Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata141);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata141Template.resolve(mbuiContext.statementContext(), name), form, metadata141);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata142)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata142Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata142);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata142Template.resolve(mbuiContext.statementContext(), name), form, metadata142);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata143)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata143Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata143);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata143Template.resolve(mbuiContext.statementContext(), name), form, metadata143);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata144)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata144Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata144);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata144Template.resolve(mbuiContext.statementContext(), name), form, metadata144);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata145)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata145Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata145);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata145Template.resolve(mbuiContext.statementContext(), name), form, metadata145);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata141)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata141Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata141Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata142)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata142Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata142Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata143)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD_SUFFIX), "Path",
                metadata143Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata143Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata144)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD_SUFFIX), "Socket Binding Group",
                metadata144Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata144Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata145)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata145Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata145Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html413;
        HTMLElement hostConfigurationItemElement = section()
            .add(html413 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata140.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(hostConfigurationForm)
            .asElement();
        handlebarElements.put("html413", html413);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html415;
        HTMLElement hostInterfaceItemElement = section()
            .add(html415 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata141.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
            .asElement();
        handlebarElements.put("html415", html415);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html418;
        HTMLElement hostJvmItemElement = section()
            .add(html418 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata142.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(hostJvmTable)
            .add(hostJvmForm)
            .asElement();
        handlebarElements.put("html418", html418);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html421;
        HTMLElement hostPathItemElement = section()
            .add(html421 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata143.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(hostPathTable)
            .add(hostPathForm)
            .asElement();
        handlebarElements.put("html421", html421);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html424;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html424 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata144.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
            .asElement();
        handlebarElements.put("html424", html424);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html427;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html427 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata145.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
            .asElement();
        handlebarElements.put("html427", html427);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html413"), "{{metadata140.getDescription().getDescription()}}", String.valueOf(metadata140.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html415"), "{{metadata141.getDescription().getDescription()}}", String.valueOf(metadata141.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html418"), "{{metadata142.getDescription().getDescription()}}", String.valueOf(metadata142.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html421"), "{{metadata143.getDescription().getDescription()}}", String.valueOf(metadata143.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html424"), "{{metadata144.getDescription().getDescription()}}", String.valueOf(metadata144.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html427"), "{{metadata145.getDescription().getDescription()}}", String.valueOf(metadata145.getDescription().getDescription()));
    }
}
