package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata147;
    private final Metadata metadata148;
    private final Metadata metadata146;
    private final Metadata metadata150;
    private final Metadata metadata149;
    private final Map<String, HTMLElement> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata147Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata147 = mbuiContext.metadataRegistry().lookup(metadata147Template);
        AddressTemplate metadata148Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata148 = mbuiContext.metadataRegistry().lookup(metadata148Template);
        AddressTemplate metadata146Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata146 = mbuiContext.metadataRegistry().lookup(metadata146Template);
        AddressTemplate metadata150Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata150 = mbuiContext.metadataRegistry().lookup(metadata150Template);
        AddressTemplate metadata149Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata149 = mbuiContext.metadataRegistry().lookup(metadata149Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata146)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata146Template.resolve(mbuiContext.statementContext()), changedValues, metadata146))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata146Template.resolve(mbuiContext.statementContext()), form, metadata146))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata147)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata147Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata147);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata147Template.resolve(mbuiContext.statementContext(), name), form, metadata147);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata148)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata148Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata148);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata148Template.resolve(mbuiContext.statementContext(), name), form, metadata148);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata149)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata149Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata149);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata149Template.resolve(mbuiContext.statementContext(), name), form, metadata149);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata150)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata150Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata150);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata150Template.resolve(mbuiContext.statementContext(), name), form, metadata150);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata147)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata147Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata147Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata148)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata148Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata148Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata149)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD_SUFFIX), "Path",
                metadata149Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata149Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata150)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata150Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata150Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html431;
        HTMLElement serverConfigurationItemElement = section()
            .add(html431 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata146.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverConfigurationForm)
            .asElement();
        handlebarElements.put("html431", html431);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html433;
        HTMLElement serverInterfaceItemElement = section()
            .add(html433 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata147.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
            .asElement();
        handlebarElements.put("html433", html433);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html436;
        HTMLElement serverJvmItemElement = section()
            .add(html436 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata148.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverJvmTable)
            .add(serverJvmForm)
            .asElement();
        handlebarElements.put("html436", html436);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html439;
        HTMLElement serverPathItemElement = section()
            .add(html439 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata149.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverPathTable)
            .add(serverPathForm)
            .asElement();
        handlebarElements.put("html439", html439);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html442;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html442 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata150.getDescription().getDescription()}}</p>"))
                .asElement())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
            .asElement();
        handlebarElements.put("html442", html442);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html431"), "{{metadata146.getDescription().getDescription()}}", String.valueOf(metadata146.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html433"), "{{metadata147.getDescription().getDescription()}}", String.valueOf(metadata147.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html436"), "{{metadata148.getDescription().getDescription()}}", String.valueOf(metadata148.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html439"), "{{metadata149.getDescription().getDescription()}}", String.valueOf(metadata149.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html442"), "{{metadata150.getDescription().getDescription()}}", String.valueOf(metadata150.getDescription().getDescription()));
    }
}
