/**
 * Represents a version consisting of a major, minor and micro part.
 * 
 * @since 0.1.0
 */
class Version {

    /**
     * @return {number} the major version number.
     */
    get major() {}

    /**
     * @return {number} the minor version number.
     */
    get minor() {}

    /**
     * @return {number} the patch version number.
     */
    get micro() {}

    /**
     * Creates a new version as a result of parsing the specified version string.
     * 
     * @param {string} version The version string to parse
     * 
     * @return {Version} a new version
     */
    static valueOf(version) {}

    /**
     * @return {string} &lt;major&gt;.&lt;minor&gt;.&lt;micro&gt;
     */
    toString() {}
}

/**
 * Instance holding information about the console and its environment.
 */
class Environment {

    /**
     * @return {Version} the HAL version.
     */
    get halVersion() {}

    /**
     * @return {InstanceInfo} information about the server instance.
     */
    get instanceInfo() {}

    /**
     * @return {boolean} true for standalone mode, false otherwise.
     */
    get standalone() {}

    /**
     * @return {string} the name of the domain controller (DC).
     */
    get domainController() {}

    /**
     * @return {Version} the management model version.
     */
    get managementVersion() {}

    /**
     * @return {boolean} true if SSO is used, false otherwise.
     */
    get singleSignOn() {}

    /**
     * @return {Roles} the standard and scoped roles.
     */
    get roles() {}
}

/**
 * Contains information about the server instance the console is connected to or loaded from (taken from the root
 * resource).
 */
class InstanceInfo {

    /**
     * @return {string} the product name.
     */
    get productName() {}

    /**
     * @return {string} the product version.
     */
    get productVersion() {}

    /**
     * @return {string} the release name.
     */
    get releaseName() {}

    /**
     * @return {string} the release version.
     */
    get releaseVersion() {}

    /**
     * @return {string} the server name.
     */
    get serverName() {}
}

/**
 * Provides access to the endpoints used in HAL.
 */
class Endpoints {

    /**
     * @return {string} the endpoint used to execute management operations.
     */
    get dmr() {}

    /**
     * @return {string} the endpoint used for file uploads.
     */
    get upload() {}

    /**
     * @return {boolean} true if the console is served from a WildFly / EAP instance, false if it runs standalone and
     * connected to an arbitrary management endpoint.
     */
    get sameOrigin() {}
}

/**
 * Holds information about an user.
 */
class User {

    /**
     * @return {string} the user name.
     */
    get name() {}

    /**
     * @return {boolean} true if this user belongs to the role SuperUser, false otherwise.
     */
    get superuser() {}

    /**
     * @return {boolean} true if this user belongs to the role Administrator, false otherwise.
     */
    get administrator() {}

    /**
     * @return {Role[]} the roles of this user.
     */
    get roles() {}

    /**
     * @return {User} the current user.
     */
    static current() {}
}

/**
 * A standard or scoped role used when RBAC is turned on.
 */
class Role {

    /**
     * Has all permissions except cannot read or write resources related to the administrative audit logging system.
     */
    static get ADMINISTRATOR() {}

    /**
     * Can read anything. Can only modify the resources related to the administrative audit logging system.
     */
    static get AUDITOR() {}

    /**
     * Like a Maintainer, but with permission to modify persistent configuration constrained to resources that are
     * considered to be "application resources". A deployment is an application resource. The messaging server is not.
     * Items like datasources and JMS destinations are not considered to be application resources by default, but this
     * is configurable.
     */
    static get DEPLOYER() {}

    /**
     * Operator permissions, plus can modify the persistent configuration.
     */
    static get MAINTAINER() {}

    /**
     * A read-only role. Cannot modify any resource.
     */
    static get MONITOR() {}

    /**
     * Monitor permissions, plus can modify runtime state, but cannot modify anything that ends up in the persistent
     * configuration. Could, for example, restart a server.
     */
    static get OPERATOR() {}

    /**
     * Has all permissions. Equivalent to a JBoss AS 7 administrator.
     */
    static get SUPER_USER() {}

    /**
     * @return {string} the unique ID of this role.
     */
    get id() {}

    /**
     * @return {boolean} true if this is a standard role, false otherwise.
     */
    get standard() {}

    /**
     * @return {boolean} true if this is a scoped role, false otherwise.
     */
    get scoped() {}

    /**
     * @return {string} the name of this role.
     */
    get name() {}

    /**
     * @return {Role} the base role if this is a scoped role, null otherwise.
     */
    get baseRole() {}

    /**
     * @return {string[]} the scopes if this is a scoped role, an empty array otherwise.
     */
    get scope() {}

    /**
     * @return {string} a string representation of this role.
     */
    toString() {}
}

/**
 * Provides access to all standard and scoped roles.
 */
class Roles {

    /**
     * @return {Role[]} all roles (standard and scoped).
     */
    get all() {}

    /**
     * @return {Role[]} standard roles.
     */
    get standardRoles() {}

    /**
     * @return {Role[]} scoped roles or an empty array if no scoped roles are defined.
     */
    get scopedRoles() {}

    /**
     * @param {string} id The unique ID of the role.
     * 
     * @return {Role} the role for that ID or null if no such role was found.
     */
    get(id) {}
}

