/**
 * Builder to create forms based on resource metadata. By default the form includes all non-deprecated attributes
 * with <code>"storage" =&gt; "configuration"</code>.
 */
class FormBuilder {

    /**
     * Use this flag if you just want to use the form to add model nodes. The attributes will be taken from the
     * ATTRIBUTES child node.
     */
    addOnly() {}

    /**
     * Use this flag if you just want to use the form to add model nodes. The attributes will be taken from the
     * REQUEST_PROPERTIES node of the ADD operation.
     */
    fromRequestProperties() {}

    /**
     * Makes the form read-only.
     */
    readOnly() {}

    /**
     * Doesn't sort the attributes alphabetically.
     */
    unsorted() {}

    /**
     * Includes only required attributes
     */
    requiredOnly() {}

    /**
     * Includes also attributes with <code>"storage" =&gt; "runtime"</code>
     */
    includeRuntime() {}

    /**
     * Includes also deprecated attributes
     */
    showDeprecated() {}

    /**
     * Creates and returns the form.
     */
    build() {}

    /**
     * Includes the specified attributes
     */
    include(attributes) {}

    /**
     * Excludes the specified attributes
     */
    exclude(attributes) {}

    /**
     * Calls the specified callback when the save button was clicked and no validation errors occurred.
     */
    onSave(callback) {}
}


class Table {

    
    get selectedRow() {}

    
    bindForm(form) {}

    
    clear() {}

    
    onSelectionChange(handler) {}
}

/**
 * A form bound to a model using well defined states and operations. The form contains a list of form items which are
 * used to view and modify the attributes of the model.
 * 
 * <p>Form items can be bound or unbound: Bound form items show the attributes of the model (text input, check boxes or
 * select boxes). They're part of the automatic data mapping between the form and the model. Unbound form items have no
 * relation to the model (static text or buttons). They are not part of the automatic data mapping.
 * 
 * @param <T> The model for this form
 */
class Form {

    
    get undefined() {}

    
    get transient() {}

    /**
     * @return {T} the current model.
     */
    get model() {}

    /**
     * Takes the specified model and updates the read-only state with the values from the model.
     * 
     * @param {T} model the model to view.
     */
    view(model) {}

    /**
     * Clears this form by removing the model reference and by clearing all form fields.
     */
    clear() {}

    /**
     * Takes the specified model and populates the editing state with the values from the model.
     * 
     * @param {T} model the model to edit.
     */
    edit(model) {}

    /**
     * Validates the form and its fields and upon successful validation persists the changes to the model and
     * calls the save callback.
     */
    save() {}

    /**
     * Cancels any modifications to the model.
     */
    cancel() {}
}

/**
 * Builder to create tables based on resource metadata. By default the table has no columns and no actions.
 */
class TableBuilder {

    /**
     * Adds a column which maps to the specified attribute.
     */
    column(attribute) {}

    /**
     * Creates and returns the table.
     */
    build() {}

    /**
     * Adds a button to add a new resource.
     * 
     * @param {string} type       The human readable resource type used in the dialog header and success message.
     * @param {AddressTemplate|string} template   The address template for the add operation. Must end in <code>&lt;resource
     * type&gt;=&lt;resource
     * name&gt;</code>.
     * @param {string[]} attributes attributes which should be part of the add resource dialog
     * @param {function(name: string, address: ResourceAddress)} callback   the callback executed after the resource has been added
     */
    add(type, template, attributes, callback) {}

    /**
     * Adds a button to remove the selected resource.
     * 
     * @param {string} type     The human readable resource type used in the success message.
     * @param {AddressTemplate|string} template The address template for the add operation. Must end in <code>&lt;resource
     * type&gt;=&lt;resource
     * @param {function(table: Table): string} name     A function to get the name of the selected resource.
     * @param {function()} callback The callback executed after the resource has been removed.
     */
    remove(type, template, name, callback) {}

    /**
     * Add a button which executes the specified callback.
     * 
     * @param {string} text    The text on the button
     * @param {string} scope   The scope: "selected" or "selectedSingle"
     * @param {function(table: Table)} handler The callback to execute when the button is clicked
     */
    button(text, scope, handler) {}

    /**
     * Adds columns for the specified attributes.
     * 
     * @param {string[]} columns The attributes
     */
    columns(columns) {}
}


class DialogBuilder {

    /**
     * Shortcut for a dialog with one 'Close' button.
     */
    closeOnly() {}

    /**
     * Shortcut for a dialog with a 'Save' and 'Cancel' button. Clicking on save will execute the specified
     * callback.
     */
    saveCancel(saveCallback) {}

    
    primary(label, callback) {}

    
    cancel() {}

    
    secondary(label, callback) {}

    
    build() {}

    
    add(element) {}

    
    okCancel(okCallback) {}

    
    size(size) {}
}

/**
 * A modal dialog with optional secondary and primary buttons. Only one dialog can be open at a time. The buttons can
 * be placed on the left or the right side. Each button has a callback. The callback is either a {@link Callback}
 * which always closes the dialog or a {@link ResultCallback} with a boolean return value. A value of {@code true}
 * indicates that the dialog should be closed whereas {@code false} keeps the dialog open. You can add as many buttons
 * as you like, but only one of them should be the primary button.
 * <p>
 * There are convenience methods to add primary and secondary buttons which come with pre-defined placements. If
 * you want to define the placement by yourself use negative numbers to place the buttons on the left side and positive
 * numbers for the right side. On each side the buttons are ordered according to the placement.
 */
class Dialog {

    
    show() {}
}

