package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata94;
    private final Metadata metadata91;
    private final Metadata metadata90;
    private final Metadata metadata93;
    private final Metadata metadata92;
    private final Metadata metadata87;
    private final Metadata metadata85;
    private final Metadata metadata89;
    private final Metadata metadata84;
    private final Metadata metadata88;
    private final Metadata metadata86;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata91Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata91 = mbuiContext.metadataRegistry().lookup(metadata91Template);
        AddressTemplate metadata90Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata90 = mbuiContext.metadataRegistry().lookup(metadata90Template);
        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        AddressTemplate metadata87Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata87 = mbuiContext.metadataRegistry().lookup(metadata87Template);
        AddressTemplate metadata85Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata85 = mbuiContext.metadataRegistry().lookup(metadata85Template);
        AddressTemplate metadata89Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata89 = mbuiContext.metadataRegistry().lookup(metadata89Template);
        AddressTemplate metadata84Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata84 = mbuiContext.metadataRegistry().lookup(metadata84Template);
        AddressTemplate metadata88Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata88 = mbuiContext.metadataRegistry().lookup(metadata88Template);
        AddressTemplate metadata86Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata86 = mbuiContext.metadataRegistry().lookup(metadata86Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-configuration-form", metadata84)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata84Template.resolve(mbuiContext.statementContext()), changedValues, metadata84))
            .prepareReset(form -> resetSingletonForm("Container", metadata84Template.resolve(mbuiContext.statementContext()), form, metadata84))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-thread-pool-form", metadata85)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata85Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata85);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata85Template.resolve(mbuiContext.statementContext(), name), form, metadata85);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-remoting-profile-form", metadata86)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata86Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata86);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata86Template.resolve(mbuiContext.statementContext(), name), form, metadata86);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-bean-pool-form", metadata87)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata87Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata87);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata87Template.resolve(mbuiContext.statementContext(), name), form, metadata87);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-cache-form", metadata88)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata88Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata88);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata88Template.resolve(mbuiContext.statementContext(), name), form, metadata88);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-passivation-form", metadata89)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata89Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata89);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata89Template.resolve(mbuiContext.statementContext(), name), form, metadata89);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-async-form", metadata90)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata90Template.resolve(mbuiContext.statementContext()), changedValues, metadata90))
            .prepareReset(form -> resetSingletonForm("Async", metadata90Template.resolve(mbuiContext.statementContext()), form, metadata90))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-iiop-form", metadata91)
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata91Template.resolve(mbuiContext.statementContext()), changedValues, metadata91))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata91Template.resolve(mbuiContext.statementContext()), form, metadata91))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-remote-form", metadata92)
            .include("cluster", "connector-ref", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata92Template.resolve(mbuiContext.statementContext()), changedValues, metadata92))
            .prepareReset(form -> resetSingletonForm("Remote", metadata92Template.resolve(mbuiContext.statementContext()), form, metadata92))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        serviceRemoteForm.getFormItem("connector-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*")));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-timer-form", metadata93)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata93Template.resolve(mbuiContext.statementContext()), changedValues, metadata93))
            .prepareReset(form -> resetSingletonForm("Timer", metadata93Template.resolve(mbuiContext.statementContext()), form, metadata93))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb-mdb-delivery-group-form", metadata94)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata94Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata94);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata94Template.resolve(mbuiContext.statementContext(), name), form, metadata94);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-thread-pool-table", metadata85)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata85Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata85Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-remoting-profile-table", metadata86)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-remoting-profile-table", Ids.ADD), "Remoting Profile",
                metadata86Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata86Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-bean-pool-table", metadata87)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-bean-pool-table", Ids.ADD), "Bean Pool",
                metadata87Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata87Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-cache-table", metadata88)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-cache-table", Ids.ADD), "Cache",
                metadata88Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata88Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-passivation-table", metadata89)
            .button(mbuiContext.tableButtonFactory().add(metadata89Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb-passivation-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata89,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata89Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata89Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb-mdb-delivery-group-table", metadata94)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-mdb-delivery-group-table", Ids.ADD), "MDB Delivery Group",
                metadata94Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata94Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb-container-item", "Container", "fa fa-cogs");
        HTMLElement html255;
        HTMLElement ejbConfigurationItemElement = section()
            .add(html255 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>${metadata84.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html255", html255);
        navigation.addSecondary("ejb-container-item", "ejb-configuration-item", "Container", ejbConfigurationItemElement);
        HTMLElement html257;
        HTMLElement ejbThreadPoolItemElement = section()
            .add(html257 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata85.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadPoolTable)
            .add(threadPoolForm)
            .asElement();
        expressionElements.put("html257", html257);
        navigation.addSecondary("ejb-container-item", "ejb-thread-pool-item", "Thread Pool", ejbThreadPoolItemElement);
        HTMLElement html260;
        HTMLElement ejbRemotingProfileItemElement = section()
            .add(html260 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>${metadata86.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remotingProfileTable)
            .add(remotingProfileForm)
            .asElement();
        expressionElements.put("html260", html260);
        navigation.addSecondary("ejb-container-item", "ejb-remoting-profile-item", "Remoting Profile", ejbRemotingProfileItemElement);
        HTMLElement html263;
        HTMLElement ejbBeanPoolItemElement = section()
            .add(html263 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>${metadata87.getDescription().getDescription()}</p>"))
                .asElement())
            .add(beanPoolTable)
            .add(beanPoolForm)
            .asElement();
        expressionElements.put("html263", html263);
        navigation.addPrimary("ejb-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejbBeanPoolItemElement);
        navigation.addPrimary("ejb-state-item", "State Management", "fa fa-list-ul");
        HTMLElement html266;
        HTMLElement ejbCacheItemElement = section()
            .add(html266 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>${metadata88.getDescription().getDescription()}</p>"))
                .asElement())
            .add(cacheTable)
            .add(cacheForm)
            .asElement();
        expressionElements.put("html266", html266);
        navigation.addSecondary("ejb-state-item", "ejb-cache-item", "Cache", ejbCacheItemElement);
        HTMLElement html269;
        HTMLElement ejbPassivationItemElement = section()
            .add(html269 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>${metadata89.getDescription().getDescription()}</p>"))
                .asElement())
            .add(passivationTable)
            .add(passivationForm)
            .asElement();
        expressionElements.put("html269", html269);
        navigation.addSecondary("ejb-state-item", "ejb-passivation-item", "Passivation", ejbPassivationItemElement);
        navigation.addPrimary("ejb-service-item", "Services", "pficon pficon-service");
        HTMLElement html272;
        HTMLElement ejbServiceAsyncItemElement = section()
            .add(html272 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>${metadata90.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceAsyncForm)
            .asElement();
        expressionElements.put("html272", html272);
        navigation.addSecondary("ejb-service-item", "ejb-service-async-item", "Async", ejbServiceAsyncItemElement);
        HTMLElement html274;
        HTMLElement ejbServiceIiopItemElement = section()
            .add(html274 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>${metadata91.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceIiopForm)
            .asElement();
        expressionElements.put("html274", html274);
        navigation.addSecondary("ejb-service-item", "ejb-service-iiop-item", "IIOP", ejbServiceIiopItemElement);
        HTMLElement html276;
        HTMLElement ejbServiceRemoteItemElement = section()
            .add(html276 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>${metadata92.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceRemoteForm)
            .asElement();
        expressionElements.put("html276", html276);
        navigation.addSecondary("ejb-service-item", "ejb-service-remote-item", "Remote", ejbServiceRemoteItemElement);
        HTMLElement html278;
        HTMLElement ejbServiceTimerItemElement = section()
            .add(html278 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceTimerForm)
            .asElement();
        expressionElements.put("html278", html278);
        navigation.addSecondary("ejb-service-item", "ejb-service-timer-item", "Timer", ejbServiceTimerItemElement);
        HTMLElement html280;
        HTMLElement ejbMdbDeliveryGroupItemElement = section()
            .add(html280 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>${metadata94.getDescription().getDescription()}</p>"))
                .asElement())
            .add(mdbDeliveryGroupTable)
            .add(mdbDeliveryGroupForm)
            .asElement();
        expressionElements.put("html280", html280);
        navigation.addPrimary("ejb-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejbMdbDeliveryGroupItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        TemplateUtil.replaceExpression(expressionElements.get("html255"), "${metadata84.getDescription().getDescription()}", String.valueOf(metadata84.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html257"), "${metadata85.getDescription().getDescription()}", String.valueOf(metadata85.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html260"), "${metadata86.getDescription().getDescription()}", String.valueOf(metadata86.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html263"), "${metadata87.getDescription().getDescription()}", String.valueOf(metadata87.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html266"), "${metadata88.getDescription().getDescription()}", String.valueOf(metadata88.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html269"), "${metadata89.getDescription().getDescription()}", String.valueOf(metadata89.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html272"), "${metadata90.getDescription().getDescription()}", String.valueOf(metadata90.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html274"), "${metadata91.getDescription().getDescription()}", String.valueOf(metadata91.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html276"), "${metadata92.getDescription().getDescription()}", String.valueOf(metadata92.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html278"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html280"), "${metadata94.getDescription().getDescription()}", String.valueOf(metadata94.getDescription().getDescription()));
    }
}
