package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_IOView extends IOView {

    private final Metadata metadata26;
    private final Metadata metadata27;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        this.expressionElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-form", metadata27)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Buffer Pool", name, metadata27Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata27);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Buffer Pool", name, metadata27Template.resolve(mbuiContext.statementContext(), name), form, metadata27);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-form", metadata26)
            .include("io-threads", "stack-size", "task-keepalive", "task-max-threads")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Worker", name, metadata26Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata26);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Worker", name, metadata26Template.resolve(mbuiContext.statementContext(), name), form, metadata26);
            })
            .build();

        bufferPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-table", metadata27)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-buffer-pool-table", Ids.ADD), "Buffer Pool",
                metadata27Template, asList("buffer-size", "buffers-per-slice", "direct-buffers"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata27Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        workerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-table", metadata26)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-worker-table", Ids.ADD), "Worker",
                metadata26Template, asList("io-threads", "stack-size", "task-keepalive", "task-max-threads"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata26Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html80;
        HTMLElement ioWorkerItemElement = section()
            .add(html80 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>${metadata26.getDescription().getDescription()}</p>"))
                .asElement())
            .add(workerTable)
            .add(workerForm)
            .asElement();
        expressionElements.put("html80", html80);
        navigation.addPrimary("io-worker-item", "Worker", "fa fa-cogs", ioWorkerItemElement);
        HTMLElement html83;
        HTMLElement ioBufferPoolItemElement = section()
            .add(html83 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>${metadata27.getDescription().getDescription()}</p>"))
                .asElement())
            .add(bufferPoolTable)
            .add(bufferPoolForm)
            .asElement();
        expressionElements.put("html83", html83);
        navigation.addPrimary("io-buffer-pool-item", "Buffer Pool", "pficon pficon-repository", ioBufferPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            bufferPoolTable.bindForm(bufferPoolForm);
            workerTable.bindForm(workerForm);

        TemplateUtil.replaceExpression(expressionElements.get("html80"), "${metadata26.getDescription().getDescription()}", String.valueOf(metadata26.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html83"), "${metadata27.getDescription().getDescription()}", String.valueOf(metadata27.getDescription().getDescription()));
    }
}
