package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final org.jboss.hal.core.CrudOperations crud;
    private final Metadata metadata105;
    private final Metadata metadata101;
    private final Metadata metadata106;
    private final Metadata metadata99;
    private final Metadata metadata98;
    private final Metadata metadata95;
    private final Metadata metadata103;
    private final Metadata metadata102;
    private final Metadata metadata97;
    private final Metadata metadata96;
    private final Metadata metadata104;
    private final Metadata metadata100;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingProfileView(MbuiContext mbuiContext, org.jboss.hal.core.CrudOperations crud) {
        super(mbuiContext);

        this.crud = crud;
        AddressTemplate metadata105Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata105 = mbuiContext.metadataRegistry().lookup(metadata105Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata106Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata106 = mbuiContext.metadataRegistry().lookup(metadata106Template);
        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata98Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata98 = mbuiContext.metadataRegistry().lookup(metadata98Template);
        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        AddressTemplate metadata104Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata104 = mbuiContext.metadataRegistry().lookup(metadata104Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        this.expressionElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata95)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .prepareReset(form -> resetRootLogger(form))
            .build();
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-form", metadata96)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .prepareReset(form -> resetLogger(form))
            .build();
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-form", metadata97)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .prepareReset(form -> resetConsoleHandler(form))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-form", metadata98)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .prepareReset(form -> resetFileHandler(form))
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata99)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicHandler(form))
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata100)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicSizeHandler(form))
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata101)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .prepareReset(form -> resetSizeHandler(form))
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-form", metadata102)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .prepareReset(form -> resetAsyncHandler(form))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-form", metadata103)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .prepareReset(form -> resetCustomHandler(form))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), customHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-form", metadata104)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .prepareReset(form -> resetSyslogHandler(form))
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-form", metadata106)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .prepareReset(form -> resetCustomFormatter(form))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-form", metadata105)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .prepareReset(form -> resetPatternFormatter(form))
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-table", metadata96)
            .button(mbuiContext.resources().constants().add(), table -> addLogger(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeLogger(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:remove)"))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-table", metadata97)
            .button(mbuiContext.resources().constants().add(), table -> addConsoleHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeConsoleHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:remove)"))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-table", metadata98)
            .button(mbuiContext.resources().constants().add(), table -> addFileHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeFileHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-table", metadata99)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-table", metadata100)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-table", metadata101)
            .button(mbuiContext.resources().constants().add(), table -> addSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-table", metadata102)
            .button(mbuiContext.resources().constants().add(), table -> addAsyncHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeAsyncHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:remove)"))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-table", metadata103)
            .button(mbuiContext.resources().constants().add(), table -> addCustomHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:remove)"))
            .columns("name", "level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-table", metadata104)
            .button(mbuiContext.resources().constants().add(), table -> addSyslogHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSyslogHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-table", metadata106)
            .button(mbuiContext.resources().constants().add(), table -> addCustomFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-table", metadata105)
            .button(mbuiContext.resources().constants().add(), table -> addPatternFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePatternFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html284;
        HTMLElement loggingProfileRootLoggerItemElement = section()
            .add(html284 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">${metadata95.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rootLoggerForm)
            .asElement();
        expressionElements.put("html284", html284);
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        HTMLElement html286;
        HTMLElement loggingProfileCategoryItemElement = section()
            .add(html286 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata96.getDescription().getDescription()}</p>"))
                .asElement())
            .add(loggerTable)
            .add(loggerForm)
            .asElement();
        expressionElements.put("html286", html286);
        navigation.addPrimary("logging-profile-category-item", "Categories", "pficon pficon-repository", loggingProfileCategoryItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html289;
        HTMLElement loggingProfileHandlerConsoleItemElement = section()
            .add(html289 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata97.getDescription().getDescription()}</p>"))
                .asElement())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
            .asElement();
        expressionElements.put("html289", html289);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        HTMLElement html292;
        HTMLElement loggingProfileHandlerFileItemElement = section()
            .add(html292 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata98.getDescription().getDescription()}</p>"))
                .asElement())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
            .asElement();
        expressionElements.put("html292", html292);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        HTMLElement html295;
        HTMLElement loggingProfileHandlerPeriodicRotatingFileItemElement = section()
            .add(html295 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata99.getDescription().getDescription()}</p>"))
                .asElement())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
            .asElement();
        expressionElements.put("html295", html295);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        HTMLElement html298;
        HTMLElement loggingProfileHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html298 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata100.getDescription().getDescription()}</p>"))
                .asElement())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
            .asElement();
        expressionElements.put("html298", html298);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html301;
        HTMLElement loggingProfileHandlerSizeRotatingFileItemElement = section()
            .add(html301 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata101.getDescription().getDescription()}</p>"))
                .asElement())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
            .asElement();
        expressionElements.put("html301", html301);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        HTMLElement html304;
        HTMLElement loggingProfileHandlerAsyncItemElement = section()
            .add(html304 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata102.getDescription().getDescription()}</p>"))
                .asElement())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
            .asElement();
        expressionElements.put("html304", html304);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        HTMLElement html307;
        HTMLElement loggingProfileHandlerCustomItemElement = section()
            .add(html307 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata103.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customHandlerTable)
            .add(customHandlerForm)
            .asElement();
        expressionElements.put("html307", html307);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        HTMLElement html310;
        HTMLElement loggingProfileHandlerSyslogItemElement = section()
            .add(html310 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata104.getDescription().getDescription()}</p>"))
                .asElement())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
            .asElement();
        expressionElements.put("html310", html310);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html313;
        HTMLElement loggingProfileFormatterPatternItemElement = section()
            .add(html313 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata105.getDescription().getDescription()}</p>"))
                .asElement())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
            .asElement();
        expressionElements.put("html313", html313);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        HTMLElement html316;
        HTMLElement loggingProfileFormatterCustomItemElement = section()
            .add(html316 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata106.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFormatterTable)
            .add(customFormatterForm)
            .asElement();
        expressionElements.put("html316", html316);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.core.CrudOperations crud() {
    return crud;
    }

    @Override
    public void attach() {
        super.attach();

            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceExpression(expressionElements.get("html284"), "${metadata95.getDescription().getDescription()}", String.valueOf(metadata95.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html286"), "${metadata96.getDescription().getDescription()}", String.valueOf(metadata96.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html289"), "${metadata97.getDescription().getDescription()}", String.valueOf(metadata97.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html292"), "${metadata98.getDescription().getDescription()}", String.valueOf(metadata98.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html295"), "${metadata99.getDescription().getDescription()}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html298"), "${metadata100.getDescription().getDescription()}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html301"), "${metadata101.getDescription().getDescription()}", String.valueOf(metadata101.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html304"), "${metadata102.getDescription().getDescription()}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html307"), "${metadata103.getDescription().getDescription()}", String.valueOf(metadata103.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html310"), "${metadata104.getDescription().getDescription()}", String.valueOf(metadata104.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html313"), "${metadata105.getDescription().getDescription()}", String.valueOf(metadata105.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html316"), "${metadata106.getDescription().getDescription()}", String.valueOf(metadata106.getDescription().getDescription()));
    }
}
