package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata65;
    private final Metadata metadata67;
    private final Metadata metadata68;
    private final Metadata metadata66;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata65Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*");
        this.metadata65 = mbuiContext.metadataRegistry().lookup(metadata65Template);
        AddressTemplate metadata67Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata67 = mbuiContext.metadataRegistry().lookup(metadata67Template);
        AddressTemplate metadata68Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata68 = mbuiContext.metadataRegistry().lookup(metadata68Template);
        AddressTemplate metadata66Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*");
        this.metadata66 = mbuiContext.metadataRegistry().lookup(metadata66Template);
        this.expressionElements = new HashMap<>();

        broadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-form", metadata65)
            .include("broadcast-period", "connectors", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BROADCAST_GROUP, form))
            .build();
        broadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-form", metadata66)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DISCOVERY_GROUP, form))
            .build();
        discoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-form", metadata67)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-form", metadata68)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();

        broadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-table", metadata65)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-table", metadata66)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        clusterConnectionTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-table", metadata67)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        groupingHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-table", metadata68)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.GROUPING_HANDLER), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.GROUPING_HANDLER, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html195;
        HTMLElement messagingBroadcastGroupItemElement = section()
            .add(html195 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Broadcast Group</h1><p>${metadata65.getDescription().getDescription()}</p>"))
                .asElement())
            .add(broadcastGroupTable)
            .add(broadcastGroupForm)
            .asElement();
        expressionElements.put("html195", html195);
        navigation.addPrimary("messaging-broadcast-group-item", "Broadcast Group", "fa fa-video-camera", messagingBroadcastGroupItemElement);
        HTMLElement html198;
        HTMLElement messagingDiscoveryGroupItemElement = section()
            .add(html198 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>${metadata66.getDescription().getDescription()}</p>"))
                .asElement())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
            .asElement();
        expressionElements.put("html198", html198);
        navigation.addPrimary("messaging-discovery-group-item", "Discovery Group", "fa fa-map-o", messagingDiscoveryGroupItemElement);
        HTMLElement html201;
        HTMLElement messagingClusterConnectionItemElement = section()
            .add(html201 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>${metadata67.getDescription().getDescription()}</p>"))
                .asElement())
            .add(clusterConnectionTable)
            .add(clusterConnectionForm)
            .asElement();
        expressionElements.put("html201", html201);
        navigation.addPrimary("messaging-cluster-connection-item", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionItemElement);
        HTMLElement html204;
        HTMLElement messagingGroupingHandlerItemElement = section()
            .add(html204 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>${metadata68.getDescription().getDescription()}</p>"))
                .asElement())
            .add(groupingHandlerTable)
            .add(groupingHandlerForm)
            .asElement();
        expressionElements.put("html204", html204);
        navigation.addPrimary("messaging-grouping-handler-item", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(broadcastGroupTable);
        registerAttachable(broadcastGroupForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            broadcastGroupTable.bindForm(broadcastGroupForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);

        TemplateUtil.replaceExpression(expressionElements.get("html195"), "${metadata65.getDescription().getDescription()}", String.valueOf(metadata65.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html198"), "${metadata66.getDescription().getDescription()}", String.valueOf(metadata66.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html201"), "${metadata67.getDescription().getDescription()}", String.valueOf(metadata67.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html204"), "${metadata68.getDescription().getDescription()}", String.valueOf(metadata68.getDescription().getDescription()));
    }
}
