package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata71;
    private final Metadata metadata70;
    private final Metadata metadata69;
    private final Metadata metadata72;
    private final Metadata metadata73;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata71Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata71 = mbuiContext.metadataRegistry().lookup(metadata71Template);
        AddressTemplate metadata70Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata70 = mbuiContext.metadataRegistry().lookup(metadata70Template);
        AddressTemplate metadata69Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata69 = mbuiContext.metadataRegistry().lookup(metadata69Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        this.expressionElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-form", metadata69)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CORE_QUEUE, form))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-form", metadata70)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_QUEUE, form))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-form", metadata71)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_TOPIC, form))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-form", metadata72)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ADDRESS_SETTING, form))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-form", metadata73)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DIVERT, form))
            .build();

        coreQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-table", metadata69)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CORE_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CORE_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("queue-address")
            .build();
        jmsQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-table", metadata70)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JMS_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("selector")
            .build();
        jmsTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-table", metadata71)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JMS_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        addressSettingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-table", metadata72)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ADDRESS_SETTING), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ADDRESS_SETTING, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        divertTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-table", metadata73)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DIVERT), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DIVERT, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html208;
        HTMLElement messagingCoreQueueItemElement = section()
            .add(html208 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>${metadata69.getDescription().getDescription()}</p>"))
                .asElement())
            .add(coreQueueTable)
            .add(coreQueueForm)
            .asElement();
        expressionElements.put("html208", html208);
        navigation.addPrimary("messaging-core-queue-item", "Core Queue", "fa fa-cog", messagingCoreQueueItemElement);
        HTMLElement html211;
        HTMLElement messagingJmsQueueItemElement = section()
            .add(html211 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>${metadata70.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jmsQueueTable)
            .add(jmsQueueForm)
            .asElement();
        expressionElements.put("html211", html211);
        navigation.addPrimary("messaging-jms-queue-item", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueItemElement);
        HTMLElement html214;
        HTMLElement messagingJmsTopicItemElement = section()
            .add(html214 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>${metadata71.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jmsTopicTable)
            .add(jmsTopicForm)
            .asElement();
        expressionElements.put("html214", html214);
        navigation.addPrimary("messaging-jms-topic-item", "JMS Topic", "fa fa-arrows", messagingJmsTopicItemElement);
        HTMLElement html217;
        HTMLElement messagingAddressSettingItemElement = section()
            .add(html217 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>${metadata72.getDescription().getDescription()}</p>"))
                .asElement())
            .add(addressSettingTable)
            .add(addressSettingForm)
            .asElement();
        expressionElements.put("html217", html217);
        navigation.addPrimary("messaging-address-setting-item", "Address Setting", "fa fa-address-card-o", messagingAddressSettingItemElement);
        HTMLElement html220;
        HTMLElement messagingDivertItemElement = section()
            .add(html220 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>${metadata73.getDescription().getDescription()}</p>"))
                .asElement())
            .add(divertTable)
            .add(divertForm)
            .asElement();
        expressionElements.put("html220", html220);
        navigation.addPrimary("messaging-divert-item", "Divert", "fa fa-exchange", messagingDivertItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        TemplateUtil.replaceExpression(expressionElements.get("html208"), "${metadata69.getDescription().getDescription()}", String.valueOf(metadata69.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html211"), "${metadata70.getDescription().getDescription()}", String.valueOf(metadata70.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html214"), "${metadata71.getDescription().getDescription()}", String.valueOf(metadata71.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html217"), "${metadata72.getDescription().getDescription()}", String.valueOf(metadata72.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html220"), "${metadata73.getDescription().getDescription()}", String.valueOf(metadata73.getDescription().getDescription()));
    }
}
