package org.jboss.hal.client.configuration.subsystem.modcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ModclusterView extends ModclusterView {

    private final Metadata metadata62;
    private final Metadata metadata63;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ModclusterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/mod-cluster-config=configuration");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/mod-cluster-config=configuration/ssl=configuration");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("modcluster-configuration", metadata62)
            .customGroup("advertising", "Advertising")
                .include("connector", "load-balancing-group", "balancer", "advertise-socket", "advertise-security-key", "advertise")
            .end()
            .customGroup("sessions", "Sessions")
                .include("sticky-session", "sticky-session-force", "sticky-session-remove")
            .end()
            .customGroup("web-contexts", "Web Contexts")
                .include("auto-enable-context", "excluded-contexts")
            .end()
            .customGroup("proxies", "Proxies")
                .include("proxy-url", "proxies")
            .end()
            .customGroup("networking", "Networking")
                .include("node-timeout", "socket-timeout", "stop-context-timeout", "max-attempts", "flush-packets", "flush-wait", "ping", "ttl", "worker-timeout")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata62Template.resolve(mbuiContext.statementContext()), changedValues, metadata62))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata62Template.resolve(mbuiContext.statementContext()), form, metadata62))
            .build();
        sslForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("modcluster-ssl-form", metadata63)
            .singleton(
                () -> new Operation.Builder(metadata63Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("modcluster-ssl-form", "SSL", metadata63Template))
            .prepareRemove(form -> removeSingletonForm("SSL", metadata63Template.resolve(mbuiContext.statementContext()), form))
            .include("key-alias", "password", "ca-certificate-file", "certificate-key-file", "cipher-suite", "ca-revocation-url", "protocol")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("SSL", metadata63Template.resolve(mbuiContext.statementContext()), changedValues, metadata63))
            .prepareReset(form -> resetSingletonForm("SSL", metadata63Template.resolve(mbuiContext.statementContext()), form, metadata63))
            .build();


        navigation = new VerticalNavigation();
        HTMLElement html188;
        HTMLElement modclusterConfigurationItemElement = section()
            .add(html188 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata62.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html188", html188);
        navigation.addPrimary("modcluster-configuration-item", "Configuration", "pficon pficon-settings", modclusterConfigurationItemElement);
        HTMLElement html190;
        HTMLElement modclusterSslItemElement = section()
            .add(html190 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>SSL</h1><p>${metadata63.getDescription().getDescription()}</p>"))
                .asElement())
            .add(sslForm)
            .asElement();
        expressionElements.put("html190", html190);
        navigation.addPrimary("modcluster-ssl-item", "SSL", "fa fa-lock", modclusterSslItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(sslForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceExpression(expressionElements.get("html188"), "${metadata62.getDescription().getDescription()}", String.valueOf(metadata62.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html190"), "${metadata63.getDescription().getDescription()}", String.valueOf(metadata63.getDescription().getDescription()));
    }
}
