package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata17;
    private final Metadata metadata12;
    private final Metadata metadata13;
    private final Metadata metadata16;
    private final Metadata metadata14;
    private final Metadata metadata15;
    private final Metadata metadata11;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata11)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-form", metadata12)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-form", metadata13)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-form", metadata14)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-form", metadata15)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-form", metadata17)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-form", metadata16)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        authenticationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-table", metadata12)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClassicAuthenticationModule(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHENTICATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authorizationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-table", metadata13)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUTHORIZATION), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHORIZATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        auditTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-table", metadata14)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUDIT), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUDIT), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        aclTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-table", metadata15)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.ACL), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.ACL), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        trustTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-table", metadata17)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.TRUST), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.TRUST), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mappingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-table", metadata16)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.MAPPING), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.MAPPING), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html37;
        HTMLElement securityDomainConfigurationItemElement = section()
            .add(html37 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html37", html37);
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        HTMLElement html39;
        HTMLElement securityDomainAuthenticationItemElement = section()
            .add(html39 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>${metadata12.getDescription().getDescription()}</p>"))
                .asElement())
            .add(authenticationTable)
            .add(authenticationForm)
            .asElement();
        expressionElements.put("html39", html39);
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        HTMLElement html42;
        HTMLElement securityDomainAuthorizationItemElement = section()
            .add(html42 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>${metadata13.getDescription().getDescription()}</p>"))
                .asElement())
            .add(authorizationTable)
            .add(authorizationForm)
            .asElement();
        expressionElements.put("html42", html42);
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        HTMLElement html45;
        HTMLElement securityDomainAuditItemElement = section()
            .add(html45 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>${metadata14.getDescription().getDescription()}</p>"))
                .asElement())
            .add(auditTable)
            .add(auditForm)
            .asElement();
        expressionElements.put("html45", html45);
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        HTMLElement html48;
        HTMLElement securityDomainAclItemElement = section()
            .add(html48 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>${metadata15.getDescription().getDescription()}</p>"))
                .asElement())
            .add(aclTable)
            .add(aclForm)
            .asElement();
        expressionElements.put("html48", html48);
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        HTMLElement html51;
        HTMLElement securityDomainMappingItemElement = section()
            .add(html51 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>${metadata16.getDescription().getDescription()}</p>"))
                .asElement())
            .add(mappingTable)
            .add(mappingForm)
            .asElement();
        expressionElements.put("html51", html51);
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        HTMLElement html54;
        HTMLElement securityDomainTrustItemElement = section()
            .add(html54 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>${metadata17.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustTable)
            .add(trustForm)
            .asElement();
        expressionElements.put("html54", html54);
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        TemplateUtil.replaceExpression(expressionElements.get("html37"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html39"), "${metadata12.getDescription().getDescription()}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html42"), "${metadata13.getDescription().getDescription()}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html45"), "${metadata14.getDescription().getDescription()}", String.valueOf(metadata14.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html48"), "${metadata15.getDescription().getDescription()}", String.valueOf(metadata15.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html51"), "${metadata16.getDescription().getDescription()}", String.valueOf(metadata16.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html54"), "${metadata17.getDescription().getDescription()}", String.valueOf(metadata17.getDescription().getDescription()));
    }
}
