package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata20;
    private final Metadata metadata23;
    private final Metadata metadata21;
    private final Metadata metadata19;
    private final Metadata metadata24;
    private final Metadata metadata22;
    private final Metadata metadata18;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata20Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata20 = mbuiContext.metadataRegistry().lookup(metadata20Template);
        AddressTemplate metadata23Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata23 = mbuiContext.metadataRegistry().lookup(metadata23Template);
        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata18)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata18Template.resolve(mbuiContext.statementContext()), changedValues, metadata18))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata18Template.resolve(mbuiContext.statementContext()), form, metadata18))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata19)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata19Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata19);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata19Template.resolve(mbuiContext.statementContext(), name), form, metadata19);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata20)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata20Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata20);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata20Template.resolve(mbuiContext.statementContext(), name), form, metadata20);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata21)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata21Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata21);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata21Template.resolve(mbuiContext.statementContext(), name), form, metadata21);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata22)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata22Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata22);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata22Template.resolve(mbuiContext.statementContext(), name), form, metadata22);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata23)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata23Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata23);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata23Template.resolve(mbuiContext.statementContext(), name), form, metadata23);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata24)
            .singleton(
                () -> new Operation.Builder(metadata24Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata24Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata24Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata24Template.resolve(mbuiContext.statementContext()), changedValues, metadata24))
            .prepareReset(form -> resetSingletonForm("Vault", metadata24Template.resolve(mbuiContext.statementContext()), form, metadata24))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata19)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata19Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata19Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata20)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata20Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata20Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata21)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata21Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata21Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata22)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata22Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata22Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata23)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata23Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata23Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html58;
        HTMLElement securityConfigurationItemElement = section()
            .add(html58 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata18.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html58", html58);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html60;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html60 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata19.getDescription().getDescription()}</p>"))
                .asElement())
            .add(keyManagerTable)
            .add(keyManagerForm)
            .asElement();
        expressionElements.put("html60", html60);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html63;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html63 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata20.getDescription().getDescription()}</p>"))
                .asElement())
            .add(keyStoreTable)
            .add(keyStoreForm)
            .asElement();
        expressionElements.put("html63", html63);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html66;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html66 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata21.getDescription().getDescription()}</p>"))
                .asElement())
            .add(realmTable)
            .add(realmForm)
            .asElement();
        expressionElements.put("html66", html66);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html69;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html69 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata22.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustManagerTable)
            .add(trustManagerForm)
            .asElement();
        expressionElements.put("html69", html69);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html72;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html72 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata23.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustStoreTable)
            .add(trustStoreForm)
            .asElement();
        expressionElements.put("html72", html72);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html75;
        HTMLElement securityVaultItemElement = section()
            .add(html75 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata24.getDescription().getDescription()}</p>"))
                .asElement())
            .add(vaultForm)
            .asElement();
        expressionElements.put("html75", html75);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceExpression(expressionElements.get("html58"), "${metadata18.getDescription().getDescription()}", String.valueOf(metadata18.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html60"), "${metadata19.getDescription().getDescription()}", String.valueOf(metadata19.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html63"), "${metadata20.getDescription().getDescription()}", String.valueOf(metadata20.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html66"), "${metadata21.getDescription().getDescription()}", String.valueOf(metadata21.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html69"), "${metadata22.getDescription().getDescription()}", String.valueOf(metadata22.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html72"), "${metadata23.getDescription().getDescription()}", String.valueOf(metadata23.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html75"), "${metadata24.getDescription().getDescription()}", String.valueOf(metadata24.getDescription().getDescription()));
    }
}
