package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata133;
    private final Metadata metadata132;
    private final Metadata metadata134;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata133Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata133 = mbuiContext.metadataRegistry().lookup(metadata133Template);
        AddressTemplate metadata132Template = AddressTemplate.of("/{selected.group}");
        this.metadata132 = mbuiContext.metadataRegistry().lookup(metadata132Template);
        AddressTemplate metadata134Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata134 = mbuiContext.metadataRegistry().lookup(metadata134Template);
        this.expressionElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata132)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata132Template.resolve(mbuiContext.statementContext()), changedValues, metadata132))
            .prepareReset(form -> resetSingletonForm("Server Group Configuration", metadata132Template.resolve(mbuiContext.statementContext()), form, metadata132))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-form", metadata133)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata133Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata133);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata133Template.resolve(mbuiContext.statementContext(), name), form, metadata133);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-form", metadata134)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata134Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata134);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata134Template.resolve(mbuiContext.statementContext(), name), form, metadata134);
            })
            .build();

        serverGroupJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-table", metadata133)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD), "Jvm",
                metadata133Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata133Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-table", metadata134)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD), "System Property",
                metadata134Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata134Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html394;
        HTMLElement serverGroupConfigurationItemElement = section()
            .add(html394 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>${metadata132.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverGroupConfigurationForm)
            .asElement();
        expressionElements.put("html394", html394);
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        HTMLElement html396;
        HTMLElement serverGroupJvmItemElement = section()
            .add(html396 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata133.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverGroupJvmTable)
            .add(serverGroupJvmForm)
            .asElement();
        expressionElements.put("html396", html396);
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        HTMLElement html399;
        HTMLElement serverGroupSystemPropertyItemElement = section()
            .add(html399 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata134.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverGroupSystemPropertyTable)
            .add(serverGroupSystemPropertyForm)
            .asElement();
        expressionElements.put("html399", html399);
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html394"), "${metadata132.getDescription().getDescription()}", String.valueOf(metadata132.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html396"), "${metadata133.getDescription().getDescription()}", String.valueOf(metadata133.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html399"), "${metadata134.getDescription().getDescription()}", String.valueOf(metadata134.getDescription().getDescription()));
    }
}
