package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata136;
    private final Metadata metadata137;
    private final Metadata metadata135;
    private final Metadata metadata139;
    private final Metadata metadata138;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata136Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata136 = mbuiContext.metadataRegistry().lookup(metadata136Template);
        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        AddressTemplate metadata135Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata135 = mbuiContext.metadataRegistry().lookup(metadata135Template);
        AddressTemplate metadata139Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata139 = mbuiContext.metadataRegistry().lookup(metadata139Template);
        AddressTemplate metadata138Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata138 = mbuiContext.metadataRegistry().lookup(metadata138Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata135)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata135Template.resolve(mbuiContext.statementContext()), changedValues, metadata135))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata135Template.resolve(mbuiContext.statementContext()), form, metadata135))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata136)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata136Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata136);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata136Template.resolve(mbuiContext.statementContext(), name), form, metadata136);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata137)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata137Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata137);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata137Template.resolve(mbuiContext.statementContext(), name), form, metadata137);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata138)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata138Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata138);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata138Template.resolve(mbuiContext.statementContext(), name), form, metadata138);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata139)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata139Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata139);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata139Template.resolve(mbuiContext.statementContext(), name), form, metadata139);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata136)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata136Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata136Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata137)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "Jvm",
                metadata137Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata137Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata138)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata138Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata138Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata139)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata139Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata139Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html403;
        HTMLElement serverConfigurationItemElement = section()
            .add(html403 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata135.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverConfigurationForm)
            .asElement();
        expressionElements.put("html403", html403);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html405;
        HTMLElement serverInterfaceItemElement = section()
            .add(html405 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata136.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
            .asElement();
        expressionElements.put("html405", html405);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html408;
        HTMLElement serverJvmItemElement = section()
            .add(html408 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverJvmTable)
            .add(serverJvmForm)
            .asElement();
        expressionElements.put("html408", html408);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html411;
        HTMLElement serverPathItemElement = section()
            .add(html411 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata138.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverPathTable)
            .add(serverPathForm)
            .asElement();
        expressionElements.put("html411", html411);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html414;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html414 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata139.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
            .asElement();
        expressionElements.put("html414", html414);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html403"), "${metadata135.getDescription().getDescription()}", String.valueOf(metadata135.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html405"), "${metadata136.getDescription().getDescription()}", String.valueOf(metadata136.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html408"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html411"), "${metadata138.getDescription().getDescription()}", String.valueOf(metadata138.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html414"), "${metadata139.getDescription().getDescription()}", String.valueOf(metadata139.getDescription().getDescription()));
    }
}
