package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata13;
    private final Metadata metadata11;
    private final Metadata metadata10;
    private final Metadata metadata9;
    private final Metadata metadata12;
    private final Metadata metadata14;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/configuration=endpoint");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        this.expressionElements = new HashMap<>();

        endpointConfigurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-endpoint-configuration", metadata9)
            .customGroup("remoting-endpoint-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-endpoint-configuration-security", mbuiContext.resources().constants().security())
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-endpoint-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Endpoint Configuration", metadata9Template.resolve(mbuiContext.statementContext()), changedValues, metadata9))
            .prepareReset(form -> resetSingletonForm("Endpoint Configuration", metadata9Template.resolve(mbuiContext.statementContext()), form, metadata9))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-form", metadata12)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetLocalOutbound(form))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-form", metadata13)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetOutbound(form))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-form", metadata14)
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 1)
            .include("protocol")
            .include("security-realm")
            .include("username")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetRemoteOutbound(form))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-connector-table", metadata10)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD), "Connector",
                metadata10Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata10Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-http-connector-table", metadata11)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD), "HTTP Connector",
                metadata11Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata11Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        localOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-table", metadata12)
            .button(mbuiContext.tableButtonFactory().add(metadata12Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata12,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata12Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata12Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-table", metadata13)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD), "Outbound",
                metadata13Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata13Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-table", metadata14)
            .button(mbuiContext.tableButtonFactory().add(metadata14Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata14,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata14Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata14Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html25;
        HTMLElement remotingEndpointConfigurationItemElement = section()
            .add(html25 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Endpoint Configuration</h1><p>${metadata9.getDescription().getDescription()}</p>"))
                .asElement())
            .add(endpointConfigurationForm)
            .asElement();
        expressionElements.put("html25", html25);
        navigation.addPrimary("remoting-endpoint-configuration-item", "Endpoint Configuration", "pficon pficon-settings", remotingEndpointConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        HTMLElement html27;
        HTMLElement remotingConnectorSubItemElement = section()
            .add(html27 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>${metadata10.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorTable)
            .asElement();
        expressionElements.put("html27", html27);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        HTMLElement html29;
        HTMLElement remotingHttpConnectorSubItemElement = section()
            .add(html29 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpConnectorTable)
            .asElement();
        expressionElements.put("html29", html29);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        HTMLElement html31;
        HTMLElement remotingLocalOutboundSubItemElement = section()
            .add(html31 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>${metadata12.getDescription().getDescription()}</p>"))
                .asElement())
            .add(localOutboundTable)
            .add(localOutboundForm)
            .asElement();
        expressionElements.put("html31", html31);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        HTMLElement html34;
        HTMLElement remotingOutboundSubItemElement = section()
            .add(html34 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>${metadata13.getDescription().getDescription()}</p>"))
                .asElement())
            .add(outboundTable)
            .add(outboundForm)
            .asElement();
        expressionElements.put("html34", html34);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        HTMLElement html37;
        HTMLElement remotingRemoteOutboundSubItemElement = section()
            .add(html37 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>${metadata14.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteOutboundTable)
            .add(remoteOutboundForm)
            .asElement();
        expressionElements.put("html37", html37);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(endpointConfigurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        TemplateUtil.replaceExpression(expressionElements.get("html25"), "${metadata9.getDescription().getDescription()}", String.valueOf(metadata9.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html27"), "${metadata10.getDescription().getDescription()}", String.valueOf(metadata10.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html29"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html31"), "${metadata12.getDescription().getDescription()}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html34"), "${metadata13.getDescription().getDescription()}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html37"), "${metadata14.getDescription().getDescription()}", String.valueOf(metadata14.getDescription().getDescription()));
    }
}
