package org.jboss.hal.core.runtime.host;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class HostSelectionEvent extends GwtEvent<HostSelectionEvent.HostSelectionHandler> { 

  java.lang.String host;

  protected HostSelectionEvent() {
    // Possibly for serialization.
  }

  public HostSelectionEvent(java.lang.String host) {
    this.host = host;
  }

  public static void fire(HasHandlers source, java.lang.String host) {
    HostSelectionEvent eventInstance = new HostSelectionEvent(host);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, HostSelectionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasHostSelectionHandlers extends HasHandlers {
    HandlerRegistration addHostSelectionHandler(HostSelectionHandler handler);
  }

  public interface HostSelectionHandler extends EventHandler {
    public void onHostSelection(HostSelectionEvent event);
  }

  private static final Type<HostSelectionHandler> TYPE = new Type<HostSelectionHandler>();

  public static Type<HostSelectionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<HostSelectionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(HostSelectionHandler handler) {
    handler.onHostSelection(this);
  }

  public java.lang.String getHost(){
    return host;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    HostSelectionEvent other = (HostSelectionEvent) obj;
    if (host == null) {
      if (other.host != null)
        return false;
    } else if (!host.equals(other.host))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (host == null ? 1 : host.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "HostSelectionEvent["
                 + host
    + "]";
  }
}
