package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata41;
    private final Metadata metadata38;
    private final Metadata metadata36;
    private final Metadata metadata40;
    private final Metadata metadata39;
    private final Metadata metadata33;
    private final Metadata metadata37;
    private final Metadata metadata31;
    private final Metadata metadata35;
    private final Metadata metadata30;
    private final Metadata metadata34;
    private final Metadata metadata32;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata33Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata33 = mbuiContext.metadataRegistry().lookup(metadata33Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=identity");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata32Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata32 = mbuiContext.metadataRegistry().lookup(metadata32Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-configuration-form", metadata30)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata30Template.resolve(mbuiContext.statementContext()), changedValues, metadata30))
            .prepareReset(form -> resetSingletonForm("Container", metadata30Template.resolve(mbuiContext.statementContext()), form, metadata30))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-form", metadata31)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata31Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata31);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata31Template.resolve(mbuiContext.statementContext(), name), form, metadata31);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-form", metadata32)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata32Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata32);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata32Template.resolve(mbuiContext.statementContext(), name), form, metadata32);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-form", metadata33)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata33Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata33);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata33Template.resolve(mbuiContext.statementContext(), name), form, metadata33);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-form", metadata34)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata34Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata34);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata34Template.resolve(mbuiContext.statementContext(), name), form, metadata34);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-form", metadata35)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata35Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata35);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata35Template.resolve(mbuiContext.statementContext(), name), form, metadata35);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-async-form", metadata36)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata36Template.resolve(mbuiContext.statementContext()), changedValues, metadata36))
            .prepareReset(form -> resetSingletonForm("Async", metadata36Template.resolve(mbuiContext.statementContext()), form, metadata36))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIdentityForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-identity-form", metadata37)
            .singleton(
                () -> new Operation.Builder(metadata37Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-identity-form", "Identity", metadata37Template))
            .prepareRemove(form -> removeSingletonForm("Identity", metadata37Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Identity", metadata37Template.resolve(mbuiContext.statementContext()), changedValues, metadata37))
            .prepareReset(form -> resetSingletonForm("Identity", metadata37Template.resolve(mbuiContext.statementContext()), form, metadata37))
            .build();
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-iiop-form", metadata38)
            .singleton(
                () -> new Operation.Builder(metadata38Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-iiop-form", "IIOP", metadata38Template))
            .prepareRemove(form -> removeSingletonForm("IIOP", metadata38Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata38Template.resolve(mbuiContext.statementContext()), changedValues, metadata38))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata38Template.resolve(mbuiContext.statementContext()), form, metadata38))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-remote-form", metadata39)
            .include("cluster", "connector-ref", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata39Template.resolve(mbuiContext.statementContext()), changedValues, metadata39))
            .prepareReset(form -> resetSingletonForm("Remote", metadata39Template.resolve(mbuiContext.statementContext()), form, metadata39))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        serviceRemoteForm.getFormItem("connector-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*")));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-timer-form", metadata40)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata40Template.resolve(mbuiContext.statementContext()), changedValues, metadata40))
            .prepareReset(form -> resetSingletonForm("Timer", metadata40Template.resolve(mbuiContext.statementContext()), form, metadata40))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-form", metadata41)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata41Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata41);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata41Template.resolve(mbuiContext.statementContext(), name), form, metadata41);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-table", metadata31)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata31Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata31Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-table", metadata32)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-remoting-profile-table", Ids.ADD), "Remoting Profile",
                metadata32Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata32Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-table", metadata33)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-bean-pool-table", Ids.ADD), "Bean Pool",
                metadata33Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata33Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-table", metadata34)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-cache-table", Ids.ADD), "Cache",
                metadata34Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata34Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-table", metadata35)
            .button(mbuiContext.tableButtonFactory().add(metadata35Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb3-passivation-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata35,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata35Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata35Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-table", metadata41)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-mdb-delivery-group-table", Ids.ADD), "MDB Delivery Group",
                metadata41Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata41Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb3-container-item", "Container", "fa fa-cogs");
        HTMLElement html87;
        HTMLElement ejb3ConfigurationItemElement = section()
            .add(html87 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>${metadata30.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html87", html87);
        navigation.addSecondary("ejb3-container-item", "ejb3-configuration-item", "Container", ejb3ConfigurationItemElement);
        HTMLElement html89;
        HTMLElement ejb3ThreadPoolItemElement = section()
            .add(html89 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata31.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadPoolTable)
            .add(threadPoolForm)
            .asElement();
        expressionElements.put("html89", html89);
        navigation.addSecondary("ejb3-container-item", "ejb3-thread-pool-item", "Thread Pool", ejb3ThreadPoolItemElement);
        HTMLElement html92;
        HTMLElement ejb3RemotingProfileItemElement = section()
            .add(html92 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>${metadata32.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remotingProfileTable)
            .add(remotingProfileForm)
            .asElement();
        expressionElements.put("html92", html92);
        navigation.addSecondary("ejb3-container-item", "ejb3-remoting-profile-item", "Remoting Profile", ejb3RemotingProfileItemElement);
        HTMLElement html95;
        HTMLElement ejb3BeanPoolItemElement = section()
            .add(html95 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>${metadata33.getDescription().getDescription()}</p>"))
                .asElement())
            .add(beanPoolTable)
            .add(beanPoolForm)
            .asElement();
        expressionElements.put("html95", html95);
        navigation.addPrimary("ejb3-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejb3BeanPoolItemElement);
        navigation.addPrimary("ejb3-state-item", "State Management", "fa fa-list-ul");
        HTMLElement html98;
        HTMLElement ejb3CacheItemElement = section()
            .add(html98 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>${metadata34.getDescription().getDescription()}</p>"))
                .asElement())
            .add(cacheTable)
            .add(cacheForm)
            .asElement();
        expressionElements.put("html98", html98);
        navigation.addSecondary("ejb3-state-item", "ejb3-cache-item", "Cache", ejb3CacheItemElement);
        HTMLElement html101;
        HTMLElement ejb3PassivationItemElement = section()
            .add(html101 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>${metadata35.getDescription().getDescription()}</p>"))
                .asElement())
            .add(passivationTable)
            .add(passivationForm)
            .asElement();
        expressionElements.put("html101", html101);
        navigation.addSecondary("ejb3-state-item", "ejb3-passivation-item", "Passivation", ejb3PassivationItemElement);
        navigation.addPrimary("ejb3-service-item", "Services", "pficon pficon-service");
        HTMLElement html104;
        HTMLElement ejb3ServiceAsyncItemElement = section()
            .add(html104 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>${metadata36.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceAsyncForm)
            .asElement();
        expressionElements.put("html104", html104);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-async-item", "Async", ejb3ServiceAsyncItemElement);
        HTMLElement html106;
        HTMLElement ejb3ServiceIdentityItemElement = section()
            .add(html106 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Identity</h1><p>${metadata37.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceIdentityForm)
            .asElement();
        expressionElements.put("html106", html106);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-identity-item", "Identity", ejb3ServiceIdentityItemElement);
        HTMLElement html108;
        HTMLElement ejb3ServiceIiopItemElement = section()
            .add(html108 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>${metadata38.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceIiopForm)
            .asElement();
        expressionElements.put("html108", html108);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-iiop-item", "IIOP", ejb3ServiceIiopItemElement);
        HTMLElement html110;
        HTMLElement ejb3ServiceRemoteItemElement = section()
            .add(html110 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>${metadata39.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceRemoteForm)
            .asElement();
        expressionElements.put("html110", html110);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-remote-item", "Remote", ejb3ServiceRemoteItemElement);
        HTMLElement html112;
        HTMLElement ejb3ServiceTimerItemElement = section()
            .add(html112 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>${metadata40.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceTimerForm)
            .asElement();
        expressionElements.put("html112", html112);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-timer-item", "Timer", ejb3ServiceTimerItemElement);
        HTMLElement html114;
        HTMLElement ejb3MdbDeliveryGroupItemElement = section()
            .add(html114 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>${metadata41.getDescription().getDescription()}</p>"))
                .asElement())
            .add(mdbDeliveryGroupTable)
            .add(mdbDeliveryGroupForm)
            .asElement();
        expressionElements.put("html114", html114);
        navigation.addPrimary("ejb3-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejb3MdbDeliveryGroupItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIdentityForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        TemplateUtil.replaceExpression(expressionElements.get("html87"), "${metadata30.getDescription().getDescription()}", String.valueOf(metadata30.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html89"), "${metadata31.getDescription().getDescription()}", String.valueOf(metadata31.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html92"), "${metadata32.getDescription().getDescription()}", String.valueOf(metadata32.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html95"), "${metadata33.getDescription().getDescription()}", String.valueOf(metadata33.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html98"), "${metadata34.getDescription().getDescription()}", String.valueOf(metadata34.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html101"), "${metadata35.getDescription().getDescription()}", String.valueOf(metadata35.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html104"), "${metadata36.getDescription().getDescription()}", String.valueOf(metadata36.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html106"), "${metadata37.getDescription().getDescription()}", String.valueOf(metadata37.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html108"), "${metadata38.getDescription().getDescription()}", String.valueOf(metadata38.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html110"), "${metadata39.getDescription().getDescription()}", String.valueOf(metadata39.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html112"), "${metadata40.getDescription().getDescription()}", String.valueOf(metadata40.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html114"), "${metadata41.getDescription().getDescription()}", String.valueOf(metadata41.getDescription().getDescription()));
    }
}
