package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final org.jboss.hal.core.CrudOperations crud;
    private final Metadata metadata77;
    private final Metadata metadata74;
    private final Metadata metadata76;
    private final Metadata metadata72;
    private final Metadata metadata71;
    private final Metadata metadata66;
    private final Metadata metadata70;
    private final Metadata metadata68;
    private final Metadata metadata69;
    private final Metadata metadata67;
    private final Metadata metadata75;
    private final Metadata metadata73;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingProfileView(MbuiContext mbuiContext, org.jboss.hal.core.CrudOperations crud) {
        super(mbuiContext);

        this.crud = crud;
        AddressTemplate metadata77Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata77 = mbuiContext.metadataRegistry().lookup(metadata77Template);
        AddressTemplate metadata74Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata74 = mbuiContext.metadataRegistry().lookup(metadata74Template);
        AddressTemplate metadata76Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata76 = mbuiContext.metadataRegistry().lookup(metadata76Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata71Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata71 = mbuiContext.metadataRegistry().lookup(metadata71Template);
        AddressTemplate metadata66Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata66 = mbuiContext.metadataRegistry().lookup(metadata66Template);
        AddressTemplate metadata70Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata70 = mbuiContext.metadataRegistry().lookup(metadata70Template);
        AddressTemplate metadata68Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata68 = mbuiContext.metadataRegistry().lookup(metadata68Template);
        AddressTemplate metadata69Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata69 = mbuiContext.metadataRegistry().lookup(metadata69Template);
        AddressTemplate metadata67Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata67 = mbuiContext.metadataRegistry().lookup(metadata67Template);
        AddressTemplate metadata75Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata75 = mbuiContext.metadataRegistry().lookup(metadata75Template);
        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        this.expressionElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata66)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .prepareReset(form -> resetRootLogger(form))
            .build();
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-form", metadata67)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .prepareReset(form -> resetLogger(form))
            .build();
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-form", metadata69)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .prepareReset(form -> resetConsoleHandler(form))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-form", metadata71)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .prepareReset(form -> resetFileHandler(form))
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata72)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicHandler(form))
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata73)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicSizeHandler(form))
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata74)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .prepareReset(form -> resetSizeHandler(form))
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-form", metadata68)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .prepareReset(form -> resetAsyncHandler(form))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-form", metadata70)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .prepareReset(form -> resetCustomHandler(form))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selected}/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), customHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-form", metadata75)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .prepareReset(form -> resetSyslogHandler(form))
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-form", metadata76)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .prepareReset(form -> resetCustomFormatter(form))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-form", metadata77)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .prepareReset(form -> resetPatternFormatter(form))
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-category-table", metadata67)
            .button(mbuiContext.resources().constants().add(), table -> addLogger(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeLogger(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:remove)"))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-table", metadata69)
            .button(mbuiContext.resources().constants().add(), table -> addConsoleHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeConsoleHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:remove)"))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-table", metadata71)
            .button(mbuiContext.resources().constants().add(), table -> addFileHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeFileHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-table", metadata72)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-table", metadata73)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-table", metadata74)
            .button(mbuiContext.resources().constants().add(), table -> addSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-table", metadata68)
            .button(mbuiContext.resources().constants().add(), table -> addAsyncHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeAsyncHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:remove)"))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-table", metadata70)
            .button(mbuiContext.resources().constants().add(), table -> addCustomHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:remove)"))
            .columns("name", "level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-table", metadata75)
            .button(mbuiContext.resources().constants().add(), table -> addSyslogHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSyslogHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-table", metadata76)
            .button(mbuiContext.resources().constants().add(), table -> addCustomFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-table", metadata77)
            .button(mbuiContext.resources().constants().add(), table -> addPatternFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePatternFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html197;
        HTMLElement loggingProfileRootLoggerItemElement = section()
            .add(html197 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">${metadata66.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rootLoggerForm)
            .asElement();
        expressionElements.put("html197", html197);
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        HTMLElement html199;
        HTMLElement loggingProfileCategoryItemElement = section()
            .add(html199 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata67.getDescription().getDescription()}</p>"))
                .asElement())
            .add(loggerTable)
            .add(loggerForm)
            .asElement();
        expressionElements.put("html199", html199);
        navigation.addPrimary("logging-profile-category-item", "Categories", "pficon pficon-repository", loggingProfileCategoryItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html202;
        HTMLElement loggingProfileHandlerAsyncItemElement = section()
            .add(html202 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata68.getDescription().getDescription()}</p>"))
                .asElement())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
            .asElement();
        expressionElements.put("html202", html202);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        HTMLElement html205;
        HTMLElement loggingProfileHandlerConsoleItemElement = section()
            .add(html205 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata69.getDescription().getDescription()}</p>"))
                .asElement())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
            .asElement();
        expressionElements.put("html205", html205);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        HTMLElement html208;
        HTMLElement loggingProfileHandlerCustomItemElement = section()
            .add(html208 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata70.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customHandlerTable)
            .add(customHandlerForm)
            .asElement();
        expressionElements.put("html208", html208);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        HTMLElement html211;
        HTMLElement loggingProfileHandlerFileItemElement = section()
            .add(html211 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata71.getDescription().getDescription()}</p>"))
                .asElement())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
            .asElement();
        expressionElements.put("html211", html211);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        HTMLElement html214;
        HTMLElement loggingProfileHandlerPeriodicRotatingFileItemElement = section()
            .add(html214 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata72.getDescription().getDescription()}</p>"))
                .asElement())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
            .asElement();
        expressionElements.put("html214", html214);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        HTMLElement html217;
        HTMLElement loggingProfileHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html217 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata73.getDescription().getDescription()}</p>"))
                .asElement())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
            .asElement();
        expressionElements.put("html217", html217);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html220;
        HTMLElement loggingProfileHandlerSizeRotatingFileItemElement = section()
            .add(html220 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata74.getDescription().getDescription()}</p>"))
                .asElement())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
            .asElement();
        expressionElements.put("html220", html220);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        HTMLElement html223;
        HTMLElement loggingProfileHandlerSyslogItemElement = section()
            .add(html223 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata75.getDescription().getDescription()}</p>"))
                .asElement())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
            .asElement();
        expressionElements.put("html223", html223);
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html226;
        HTMLElement loggingProfileFormatterCustomItemElement = section()
            .add(html226 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata76.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFormatterTable)
            .add(customFormatterForm)
            .asElement();
        expressionElements.put("html226", html226);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);
        HTMLElement html229;
        HTMLElement loggingProfileFormatterPatternItemElement = section()
            .add(html229 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata77.getDescription().getDescription()}</p>"))
                .asElement())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
            .asElement();
        expressionElements.put("html229", html229);
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.core.CrudOperations crud() {
    return crud;
    }

    @Override
    public void attach() {
        super.attach();

            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceExpression(expressionElements.get("html197"), "${metadata66.getDescription().getDescription()}", String.valueOf(metadata66.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html199"), "${metadata67.getDescription().getDescription()}", String.valueOf(metadata67.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html202"), "${metadata68.getDescription().getDescription()}", String.valueOf(metadata68.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html205"), "${metadata69.getDescription().getDescription()}", String.valueOf(metadata69.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html208"), "${metadata70.getDescription().getDescription()}", String.valueOf(metadata70.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html211"), "${metadata71.getDescription().getDescription()}", String.valueOf(metadata71.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html214"), "${metadata72.getDescription().getDescription()}", String.valueOf(metadata72.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html217"), "${metadata73.getDescription().getDescription()}", String.valueOf(metadata73.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html220"), "${metadata74.getDescription().getDescription()}", String.valueOf(metadata74.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html223"), "${metadata75.getDescription().getDescription()}", String.valueOf(metadata75.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html226"), "${metadata76.getDescription().getDescription()}", String.valueOf(metadata76.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html229"), "${metadata77.getDescription().getDescription()}", String.valueOf(metadata77.getDescription().getDescription()));
    }
}
