package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_FilterView extends FilterView {

    private final Metadata metadata18;
    private final Metadata metadata17;
    private final Metadata metadata20;
    private final Metadata metadata16;
    private final Metadata metadata22;
    private final Metadata metadata19;
    private final Metadata metadata23;
    private final Metadata metadata21;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata20Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata20 = mbuiContext.metadataRegistry().lookup(metadata20Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        AddressTemplate metadata23Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata23 = mbuiContext.metadataRegistry().lookup(metadata23Template);
        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        this.expressionElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-form", metadata16)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata16Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata16);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Filter", name, metadata16Template.resolve(mbuiContext.statementContext(), name), form, metadata16);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-form", metadata17)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata17Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata17);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Error Page", name, metadata17Template.resolve(mbuiContext.statementContext(), name), form, metadata17);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-form", metadata18)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata18Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata18);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Expression Filter", name, metadata18Template.resolve(mbuiContext.statementContext(), name), form, metadata18);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-form", metadata19)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-form", metadata20)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("security-realm")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 27)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata20Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata20);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Mod Cluster", name, metadata20Template.resolve(mbuiContext.statementContext(), name), form, metadata20);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-form", metadata21)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata21Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata21);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Request Limit", name, metadata21Template.resolve(mbuiContext.statementContext(), name), form, metadata21);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-form", metadata22)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .prepareReset(form -> presenter.resetResponseHeader(form))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-form", metadata23)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata23Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata23);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Rewrite", name, metadata23Template.resolve(mbuiContext.statementContext(), name), form, metadata23);
            })
            .build();

        customFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-table", metadata16)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD), "Custom Filter",
                metadata16Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata16Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        errorPageTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-table", metadata17)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD), "Error Page",
                metadata17Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata17Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("code")
            .build();
        expressionFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-table", metadata18)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD), "Expression Filter",
                metadata18Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata18Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("expression")
            .build();
        gzipTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-table", metadata19)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD), "GZip",
                metadata19Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata19Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        modClusterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-table", metadata20)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD), "Mod Cluster",
                metadata20Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata20Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("management-socket-binding")
            .build();
        requestLimitTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-table", metadata21)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD), "Request Limit",
                metadata21Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata21Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("max-concurrent-requests")
            .build();
        responseHeaderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-table", metadata22)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addResponseHeader(), Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeResponseHeader(table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-name").asString()).asString())
            .column("value", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-value").asString()).asString())
            .build();
        rewriteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-table", metadata23)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD), "Rewrite",
                metadata23Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata23Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("target")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html45;
        HTMLElement undertowCustomFilterItemElement = section()
            .add(html45 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>${metadata16.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFilterTable)
            .add(customFilterForm)
            .asElement();
        expressionElements.put("html45", html45);
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        HTMLElement html48;
        HTMLElement undertowErrorPageItemElement = section()
            .add(html48 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>${metadata17.getDescription().getDescription()}</p>"))
                .asElement())
            .add(errorPageTable)
            .add(errorPageForm)
            .asElement();
        expressionElements.put("html48", html48);
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        HTMLElement html51;
        HTMLElement undertowExpressionFilterItemElement = section()
            .add(html51 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>${metadata18.getDescription().getDescription()}</p>"))
                .asElement())
            .add(expressionFilterTable)
            .add(expressionFilterForm)
            .asElement();
        expressionElements.put("html51", html51);
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        HTMLElement html54;
        HTMLElement undertowGzipItemElement = section()
            .add(html54 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>${metadata19.getDescription().getDescription()}</p>"))
                .asElement())
            .add(gzipTable)
            .add(gzipForm)
            .asElement();
        expressionElements.put("html54", html54);
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        HTMLElement html57;
        HTMLElement undertowModClusterItemElement = section()
            .add(html57 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>${metadata20.getDescription().getDescription()}</p>"))
                .asElement())
            .add(modClusterTable)
            .add(modClusterForm)
            .asElement();
        expressionElements.put("html57", html57);
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        HTMLElement html60;
        HTMLElement undertowRequestLimitItemElement = section()
            .add(html60 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>${metadata21.getDescription().getDescription()}</p>"))
                .asElement())
            .add(requestLimitTable)
            .add(requestLimitForm)
            .asElement();
        expressionElements.put("html60", html60);
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        HTMLElement html63;
        HTMLElement undertowResponseHeaderItemElement = section()
            .add(html63 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>${metadata22.getDescription().getDescription()}</p>"))
                .asElement())
            .add(responseHeaderTable)
            .add(responseHeaderForm)
            .asElement();
        expressionElements.put("html63", html63);
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        HTMLElement html66;
        HTMLElement undertowRewriteItemElement = section()
            .add(html66 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>${metadata23.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rewriteTable)
            .add(rewriteForm)
            .asElement();
        expressionElements.put("html66", html66);
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        TemplateUtil.replaceExpression(expressionElements.get("html45"), "${metadata16.getDescription().getDescription()}", String.valueOf(metadata16.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html48"), "${metadata17.getDescription().getDescription()}", String.valueOf(metadata17.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html51"), "${metadata18.getDescription().getDescription()}", String.valueOf(metadata18.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html54"), "${metadata19.getDescription().getDescription()}", String.valueOf(metadata19.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html57"), "${metadata20.getDescription().getDescription()}", String.valueOf(metadata20.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html60"), "${metadata21.getDescription().getDescription()}", String.valueOf(metadata21.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html63"), "${metadata22.getDescription().getDescription()}", String.valueOf(metadata22.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html66"), "${metadata23.getDescription().getDescription()}", String.valueOf(metadata23.getDescription().getDescription()));
    }
}
