package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_PathsView extends PathsView {

    private final Metadata metadata128;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_PathsView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata128Template = AddressTemplate.of("/path=*");
        this.metadata128 = mbuiContext.metadataRegistry().lookup(metadata128Template);
        this.expressionElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("path-form", metadata128)
            .include("name", "path", "relative-to")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata128Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata128);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata128Template.resolve(mbuiContext.statementContext(), name), form, metadata128);
            })
            .build();
        form.getFormItem("relative-to").registerSuggestHandler(new PathsAutoComplete());

        table = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("path-table", metadata128)
            .button(mbuiContext.tableButtonFactory().add(metadata128Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("path-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Path"),
                    metadata128,
                    asList("name", "path", "relative-to"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata128Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Path", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("name").addValidationHandler(new org.jboss.hal.ballroom.form.BlacklistValidation("jboss.home", "user.home", "user.dir", "java.home", "jboss.server.base.dir"));
                dialog.getForm().getFormItem("relative-to").registerSuggestHandler(new PathsAutoComplete());
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata128Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();

        HTMLElement html382;
        HTMLElement root = row()
            .add(column()
                .add(html382 = div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata128.getDescription().getDescription()}</p>"))
                    .asElement())
                                .add(table)
                                .add(form)
                )
            .asElement();
        expressionElements.put("html382", html382);

        registerAttachable(table);
        registerAttachable(form);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            table.bindForm(form);

        TemplateUtil.replaceExpression(expressionElements.get("html382"), "${metadata128.getDescription().getDescription()}", String.valueOf(metadata128.getDescription().getDescription()));
    }
}
