package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_BatchView extends BatchView {

    private final Metadata metadata59;
    private final Metadata metadata58;
    private final Metadata metadata55;
    private final Metadata metadata57;
    private final Metadata metadata56;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata55Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata55 = mbuiContext.metadataRegistry().lookup(metadata55Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("batch-configuration-form", metadata55)
            .onSave((form, changedValues) -> saveSingletonForm("Subsystem", metadata55Template.resolve(mbuiContext.statementContext()), changedValues, metadata55))
            .prepareReset(form -> resetSingletonForm("Subsystem", metadata55Template.resolve(mbuiContext.statementContext()), form, metadata55))
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-form", metadata57)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JDBC Job Repository", name, metadata57Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata57);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*")));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-form", metadata58)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Factory", name, metadata58Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata58);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Factory", name, metadata58Template.resolve(mbuiContext.statementContext(), name), form, metadata58);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-form", metadata59)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata59Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata59);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata59Template.resolve(mbuiContext.statementContext(), name), form, metadata59);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*")));

        inMemoryJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-in-memory-job-repo-table", metadata56)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-in-memory-job-repo-table", Ids.ADD), "In Memory Job",
                metadata56Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata56Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        jdbcJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-table", metadata57)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-jdbc-job-repo-table", Ids.ADD), "JDBC Job Repository",
                metadata57Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata57Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        threadFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-table", metadata58)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-factory-table", Ids.ADD), "Thread Factory",
                metadata58Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata58Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-table", metadata59)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata59Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata59Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html167;
        HTMLElement batchConfigurationItemElement = section()
            .add(html167 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata55.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html167", html167);
        navigation.addPrimary("batch-configuration-item", "Configuration", "pficon pficon-settings", batchConfigurationItemElement);
        HTMLElement html169;
        HTMLElement batchInMemoryJobRepoItemElement = section()
            .add(html169 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>${metadata56.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inMemoryJobRepoTable)
            .asElement();
        expressionElements.put("html169", html169);
        navigation.addPrimary("batch-in-memory-job-repo-item", "In Memory", "pficon pficon-memory", batchInMemoryJobRepoItemElement);
        HTMLElement html171;
        HTMLElement batchJdbcJobRepoItemElement = section()
            .add(html171 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>${metadata57.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jdbcJobRepoTable)
            .add(jdbcJobRepoForm)
            .asElement();
        expressionElements.put("html171", html171);
        navigation.addPrimary("batch-jdbc-job-repo-item", "JDBC", "fa fa-database", batchJdbcJobRepoItemElement);
        HTMLElement html174;
        HTMLElement batchThreadFactoryItemElement = section()
            .add(html174 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>${metadata58.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadFactoryTable)
            .add(threadFactoryForm)
            .asElement();
        expressionElements.put("html174", html174);
        navigation.addPrimary("batch-thread-factory-item", "Thread Factory", "pficon pficon-service", batchThreadFactoryItemElement);
        HTMLElement html177;
        HTMLElement batchThreadPoolItemElement = section()
            .add(html177 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadPoolTable)
            .add(threadPoolForm)
            .asElement();
        expressionElements.put("html177", html177);
        navigation.addPrimary("batch-thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", batchThreadPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            jdbcJobRepoTable.bindForm(jdbcJobRepoForm);
            threadFactoryTable.bindForm(threadFactoryForm);
            threadPoolTable.bindForm(threadPoolForm);

        TemplateUtil.replaceExpression(expressionElements.get("html167"), "${metadata55.getDescription().getDescription()}", String.valueOf(metadata55.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html169"), "${metadata56.getDescription().getDescription()}", String.valueOf(metadata56.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html171"), "${metadata57.getDescription().getDescription()}", String.valueOf(metadata57.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html174"), "${metadata58.getDescription().getDescription()}", String.valueOf(metadata58.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html177"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
    }
}
