package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HandlerView extends HandlerView {

    private final Metadata metadata129;
    private final Metadata metadata128;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HandlerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata129Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=handler/reverse-proxy=*");
        this.metadata129 = mbuiContext.metadataRegistry().lookup(metadata129Template);
        AddressTemplate metadata128Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=handler/file=*");
        this.metadata128 = mbuiContext.metadataRegistry().lookup(metadata128Template);
        this.expressionElements = new HashMap<>();

        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-file-handler-form", metadata128)
            .include("cache-buffer-size")
            .include("cache-buffers")
            .include("case-sensitive")
            .include("directory-listing")
            .include("follow-symlink")
            .include("path")
            .include("safe-symlink-paths")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisHandler()), 7)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata128Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata128);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata128Template.resolve(mbuiContext.statementContext(), name), form, metadata128);
            })
            .build();
        reverseProxyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-reverse-proxy-form", metadata129)
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("max-request-time")
            .include("max-retries")
            .include("problem-server-retry")
            .include("request-queue-size")
            .include("session-cookie-names")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisHandler()), 8)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Reverse Proxy", name, metadata129Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata129);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Reverse Proxy", name, metadata129Template.resolve(mbuiContext.statementContext(), name), form, metadata129);
            })
            .build();

        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-file-handler-table", metadata128)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-file-handler-table", Ids.ADD), "File Handler",
                metadata128Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata128Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("path")
            .build();
        reverseProxyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-reverse-proxy-table", metadata129)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-reverse-proxy-table", Ids.ADD), "Reverse Proxy",
                metadata129Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Reverse Proxy", metadata129Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html382;
        HTMLElement undertowFileHandlerItemElement = section()
            .add(html382 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata128.getDescription().getDescription()}</p>"))
                .asElement())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
            .asElement();
        expressionElements.put("html382", html382);
        navigation.addPrimary("undertow-file-handler-item", "File Handler", "fa fa-file-text-o", undertowFileHandlerItemElement);
        HTMLElement html385;
        HTMLElement undertowReverseProxyItemElement = section()
            .add(html385 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Reverse Proxy</h1><p>${metadata129.getDescription().getDescription()}</p>"))
                .asElement())
            .add(reverseProxyTable)
            .add(reverseProxyForm)
            .asElement();
        expressionElements.put("html385", html385);
        navigation.addPrimary("undertow-reverse-proxy-item", "Reverse Proxy", "fa fa-undo", undertowReverseProxyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(reverseProxyTable);
        registerAttachable(reverseProxyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            fileHandlerTable.bindForm(fileHandlerForm);
            reverseProxyTable.bindForm(reverseProxyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html382"), "${metadata128.getDescription().getDescription()}", String.valueOf(metadata128.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html385"), "${metadata129.getDescription().getDescription()}", String.valueOf(metadata129.getDescription().getDescription()));
    }
}
