package org.jboss.hal.client.configuration.subsystem.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_TransactionView extends TransactionView {

    private final Metadata metadata127;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_TransactionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata127Template = AddressTemplate.of("/{selected.profile}/subsystem=transactions");
        this.metadata127 = mbuiContext.metadataRegistry().lookup(metadata127Template);
        this.expressionElements = new HashMap<>();

        attributesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-attributes-form", metadata127)
            .include("default-timeout", "enable-tsm-status", "journal-store-enable-async-io", "jts", "maximum-timeout", "node-identifier", "statistics-enabled", "use-journal-store")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Transaction Manager", metadata127Template.resolve(mbuiContext.statementContext()), changedValues, metadata127))
            .prepareReset(form -> resetSingletonForm("Transaction Manager", metadata127Template.resolve(mbuiContext.statementContext()), form, metadata127))
            .build();
        processForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-process-form", metadata127)
            .include("process-id-uuid", "process-id-socket-binding", "process-id-socket-max-ports")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Process ID", metadata127Template.resolve(mbuiContext.statementContext()), changedValues, metadata127))
            .prepareReset(form -> resetSingletonForm("Process ID", metadata127Template.resolve(mbuiContext.statementContext()), form, metadata127))
            .build();
        processForm.getFormItem("process-id-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-recovery-form", metadata127)
            .include("socket-binding", "status-socket-binding", "recovery-listener")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Recovery", metadata127Template.resolve(mbuiContext.statementContext()), changedValues, metadata127))
            .prepareReset(form -> resetSingletonForm("Recovery", metadata127Template.resolve(mbuiContext.statementContext()), form, metadata127))
            .build();
        recoveryForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm.getFormItem("status-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        pathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-path-form", metadata127)
            .include("object-store-path", "object-store-relative-to")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Path", metadata127Template.resolve(mbuiContext.statementContext()), changedValues, metadata127))
            .prepareReset(form -> resetSingletonForm("Path", metadata127Template.resolve(mbuiContext.statementContext()), form, metadata127))
            .build();
        pathForm.getFormItem("object-store-relative-to").registerSuggestHandler(new org.jboss.hal.client.configuration.PathsAutoComplete());
        jdbcForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-jdbc-form", metadata127)
            .include("use-jdbc-store", "jdbc-action-store-drop-table", "jdbc-action-store-table-prefix", "jdbc-communication-store-drop-table", "jdbc-communication-store-table-prefix", "jdbc-state-store-drop-table", "jdbc-state-store-table-prefix", "jdbc-store-datasource")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("JDBC", metadata127Template.resolve(mbuiContext.statementContext()), changedValues, metadata127))
            .prepareReset(form -> resetSingletonForm("JDBC", metadata127Template.resolve(mbuiContext.statementContext()), form, metadata127))
            .build();
        List<AddressTemplate> jdbcFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        jdbcForm.getFormItem("jdbc-store-datasource").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), jdbcFormTemplates));


        navigation = new VerticalNavigation();
        HTMLElement html371;
        HTMLElement txAttributesConfigItemElement = section()
            .add(html371 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Transaction Manager</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                .asElement())
            .add(attributesForm)
            .asElement();
        expressionElements.put("html371", html371);
        navigation.addPrimary("tx-attributes-config-item", "Configuration", "pficon pficon-settings", txAttributesConfigItemElement);
        HTMLElement html373;
        HTMLElement txProcessItemElement = section()
            .add(html373 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process ID</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                .asElement())
            .add(processForm)
            .asElement();
        expressionElements.put("html373", html373);
        navigation.addPrimary("tx-process-item", "Process", "pficon pficon-service", txProcessItemElement);
        HTMLElement html375;
        HTMLElement txRecoveryConfigItemElement = section()
            .add(html375 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Recovery</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                .asElement())
            .add(recoveryForm)
            .asElement();
        expressionElements.put("html375", html375);
        navigation.addPrimary("tx-recovery-config-item", "Recovery", "fa fa-repeat", txRecoveryConfigItemElement);
        HTMLElement html377;
        HTMLElement txPathConfigItemElement = section()
            .add(html377 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Path</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                .asElement())
            .add(pathForm)
            .asElement();
        expressionElements.put("html377", html377);
        navigation.addPrimary("tx-path-config-item", "Path", "fa fa-folder-open", txPathConfigItemElement);
        HTMLElement html379;
        HTMLElement txJdbcConfigItemElement = section()
            .add(html379 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jdbcForm)
            .asElement();
        expressionElements.put("html379", html379);
        navigation.addPrimary("tx-jdbc-config-item", "JDBC", "fa fa-database", txJdbcConfigItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(attributesForm);
        registerAttachable(processForm);
        registerAttachable(recoveryForm);
        registerAttachable(pathForm);
        registerAttachable(jdbcForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceExpression(expressionElements.get("html371"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html373"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html375"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html377"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html379"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
    }
}
