package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_FilterView extends FilterView {

    private final Metadata metadata100;
    private final Metadata metadata99;
    private final Metadata metadata102;
    private final Metadata metadata98;
    private final Metadata metadata104;
    private final Metadata metadata101;
    private final Metadata metadata105;
    private final Metadata metadata103;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata98Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata98 = mbuiContext.metadataRegistry().lookup(metadata98Template);
        AddressTemplate metadata104Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata104 = mbuiContext.metadataRegistry().lookup(metadata104Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata105Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata105 = mbuiContext.metadataRegistry().lookup(metadata105Template);
        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        this.expressionElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-form", metadata98)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata98Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata98);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Filter", name, metadata98Template.resolve(mbuiContext.statementContext(), name), form, metadata98);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-form", metadata99)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata99Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata99);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Error Page", name, metadata99Template.resolve(mbuiContext.statementContext(), name), form, metadata99);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-form", metadata100)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata100Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata100);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Expression Filter", name, metadata100Template.resolve(mbuiContext.statementContext(), name), form, metadata100);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-form", metadata101)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-form", metadata102)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("security-realm")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 27)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata102Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata102);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Mod Cluster", name, metadata102Template.resolve(mbuiContext.statementContext(), name), form, metadata102);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-form", metadata103)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata103Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata103);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Request Limit", name, metadata103Template.resolve(mbuiContext.statementContext(), name), form, metadata103);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-form", metadata104)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .prepareReset(form -> presenter.resetResponseHeader(form))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-form", metadata105)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata105Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata105);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Rewrite", name, metadata105Template.resolve(mbuiContext.statementContext(), name), form, metadata105);
            })
            .build();

        customFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-table", metadata98)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD), "Custom Filter",
                metadata98Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata98Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        errorPageTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-table", metadata99)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD), "Error Page",
                metadata99Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata99Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("code")
            .build();
        expressionFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-table", metadata100)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD), "Expression Filter",
                metadata100Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata100Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("expression")
            .build();
        gzipTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-table", metadata101)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD), "GZip",
                metadata101Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata101Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        modClusterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-table", metadata102)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD), "Mod Cluster",
                metadata102Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata102Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("management-socket-binding")
            .build();
        requestLimitTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-table", metadata103)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD), "Request Limit",
                metadata103Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata103Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("max-concurrent-requests")
            .build();
        responseHeaderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-table", metadata104)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addResponseHeader(), Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeResponseHeader(table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-name").asString()).asString())
            .column("value", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-value").asString()).asString())
            .build();
        rewriteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-table", metadata105)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD), "Rewrite",
                metadata105Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata105Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("target")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html283;
        HTMLElement undertowCustomFilterItemElement = section()
            .add(html283 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>${metadata98.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFilterTable)
            .add(customFilterForm)
            .asElement();
        expressionElements.put("html283", html283);
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        HTMLElement html286;
        HTMLElement undertowErrorPageItemElement = section()
            .add(html286 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>${metadata99.getDescription().getDescription()}</p>"))
                .asElement())
            .add(errorPageTable)
            .add(errorPageForm)
            .asElement();
        expressionElements.put("html286", html286);
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        HTMLElement html289;
        HTMLElement undertowExpressionFilterItemElement = section()
            .add(html289 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>${metadata100.getDescription().getDescription()}</p>"))
                .asElement())
            .add(expressionFilterTable)
            .add(expressionFilterForm)
            .asElement();
        expressionElements.put("html289", html289);
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        HTMLElement html292;
        HTMLElement undertowGzipItemElement = section()
            .add(html292 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>${metadata101.getDescription().getDescription()}</p>"))
                .asElement())
            .add(gzipTable)
            .add(gzipForm)
            .asElement();
        expressionElements.put("html292", html292);
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        HTMLElement html295;
        HTMLElement undertowModClusterItemElement = section()
            .add(html295 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>${metadata102.getDescription().getDescription()}</p>"))
                .asElement())
            .add(modClusterTable)
            .add(modClusterForm)
            .asElement();
        expressionElements.put("html295", html295);
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        HTMLElement html298;
        HTMLElement undertowRequestLimitItemElement = section()
            .add(html298 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>${metadata103.getDescription().getDescription()}</p>"))
                .asElement())
            .add(requestLimitTable)
            .add(requestLimitForm)
            .asElement();
        expressionElements.put("html298", html298);
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        HTMLElement html301;
        HTMLElement undertowResponseHeaderItemElement = section()
            .add(html301 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>${metadata104.getDescription().getDescription()}</p>"))
                .asElement())
            .add(responseHeaderTable)
            .add(responseHeaderForm)
            .asElement();
        expressionElements.put("html301", html301);
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        HTMLElement html304;
        HTMLElement undertowRewriteItemElement = section()
            .add(html304 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>${metadata105.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rewriteTable)
            .add(rewriteForm)
            .asElement();
        expressionElements.put("html304", html304);
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        TemplateUtil.replaceExpression(expressionElements.get("html283"), "${metadata98.getDescription().getDescription()}", String.valueOf(metadata98.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html286"), "${metadata99.getDescription().getDescription()}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html289"), "${metadata100.getDescription().getDescription()}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html292"), "${metadata101.getDescription().getDescription()}", String.valueOf(metadata101.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html295"), "${metadata102.getDescription().getDescription()}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html298"), "${metadata103.getDescription().getDescription()}", String.valueOf(metadata103.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html301"), "${metadata104.getDescription().getDescription()}", String.valueOf(metadata104.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html304"), "${metadata105.getDescription().getDescription()}", String.valueOf(metadata105.getDescription().getDescription()));
    }
}
