/*
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.hal.client.bootstrap.tasks;

import javax.inject.Inject;

/** Simple wrapper around an ordered array of bootstrap tasks. */
public class BootstrapTasks {

    private final BootstrapTask[] tasks;

    @Inject
    public BootstrapTasks(InjectPolyfill injectPolyfill,
            ReadEnvironment readEnvironment,
            ReadAuthentication readAuthentication,
            FindDomainController findDomainController,
            RegisterStaticCapabilities registerStaticCapabilities,
            ReadExtensions readExtensions,
            LoadSettings loadSettings,
            StartAnalytics startAnalytics) {
        this.tasks = new BootstrapTask[]{
                injectPolyfill,
                readEnvironment,
                readAuthentication,
                findDomainController,
                registerStaticCapabilities,
                readExtensions,
                loadSettings,
                startAnalytics,
        };
    }

    public BootstrapTask[] tasks() {
        return tasks;
    }
}
