package org.jboss.hal.client.configuration.subsystem.modcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ModclusterView extends ModclusterView {

    private final Metadata metadata7;
    private final Metadata metadata6;
    private final Metadata metadata8;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ModclusterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/proxy=*/dynamic-load-provider=configuration/custom-load-metric=*");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/proxy=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/proxy=*/dynamic-load-provider=configuration/load-metric=*");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("proxy-conf-form", metadata6)
            .customGroup("advertising", "Advertising")
                .include("advertise", "advertise-security-key", "advertise-socket", "balancer", "connector", "load-balancing-group", "simple-load-provider")
            .end()
            .customGroup("sessions", "Sessions")
                .include("sticky-session", "sticky-session-force", "sticky-session-remove")
            .end()
            .customGroup("web-contexts", "Web Contexts")
                .include("auto-enable-context", "excluded-contexts", "session-draining-strategy")
            .end()
            .customGroup("proxies", "Proxies")
                .include("proxies", "proxy-url", "ssl-context")
            .end()
            .customGroup("networking", "Networking")
                .include("flush-packets", "flush-wait", "max-attempts", "node-timeout", "ping", "smax", "socket-timeout", "status-interval", "stop-context-timeout", "ttl", "worker-timeout")
            .end()
            .onSave((form, changedValues) -> {
                String name = presenter.getProxyName();
                saveForm("Configuration", name, metadata6Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata6);
            })
            .prepareReset(form -> {
                String name = presenter.getProxyName();
                resetForm("Configuration", name, metadata6Template.resolve(mbuiContext.statementContext(), name), form, metadata6);
            })
            .build();
        loadMetricForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("load-metrics-form", metadata8)
            .onSave((form, changedValues) -> presenter.saveLoadMetric(form, changedValues))
            .prepareReset(form -> presenter.prepareResetLoadMetric(form))
            .build();
        customLoadMetricForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("custom-load-metrics-form", metadata7)
            .onSave((form, changedValues) -> presenter.saveCustomLoadMetric(form, changedValues))
            .prepareReset(form -> presenter.prepareResetCustomLoadMetric(form))
            .build();

        loadMetricTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("load-metrics-table", metadata8)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addLoadMetric(), Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/dynamic-load-provider=configuration/load-metric=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeLoadMetric(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/dynamic-load-provider=configuration/load-metric=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customLoadMetricTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("custom-load-metrics-table", metadata7)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addCustomLoadMetric(), Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/dynamic-load-provider=configuration/custom-load-metric=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeCustomLoadMetric(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/dynamic-load-provider=configuration/custom-load-metric=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html18;
        HTMLElement proxyItemElement = section()
            .add(html18 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata6.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html18", html18);
        navigation.addPrimary("proxy-item", "Configuration", "pficon pficon-settings", proxyItemElement);
        HTMLElement html20;
        HTMLElement customLoadMetricsItemElement = section()
            .add(html20 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Load Metrics</h1><p>${metadata7.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customLoadMetricTable)
            .add(customLoadMetricForm)
            .asElement();
        expressionElements.put("html20", html20);
        navigation.addPrimary("custom-load-metrics-item", "Custom Load Metrics", "pficon pficon-service", customLoadMetricsItemElement);
        HTMLElement html23;
        HTMLElement loadMetricsItemElement = section()
            .add(html23 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Load Metrics</h1><p>${metadata8.getDescription().getDescription()}</p>"))
                .asElement())
            .add(loadMetricTable)
            .add(loadMetricForm)
            .asElement();
        expressionElements.put("html23", html23);
        navigation.addPrimary("load-metrics-item", "Load Metrics", "fa fa-map", loadMetricsItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(loadMetricTable);
        registerAttachable(loadMetricForm);
        registerAttachable(customLoadMetricTable);
        registerAttachable(customLoadMetricForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loadMetricTable.bindForm(loadMetricForm);
            customLoadMetricTable.bindForm(customLoadMetricForm);

        TemplateUtil.replaceExpression(expressionElements.get("html18"), "${metadata6.getDescription().getDescription()}", String.valueOf(metadata6.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html20"), "${metadata7.getDescription().getDescription()}", String.valueOf(metadata7.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html23"), "${metadata8.getDescription().getDescription()}", String.valueOf(metadata8.getDescription().getDescription()));
    }
}
