package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata139;
    private final Metadata metadata138;
    private final Metadata metadata137;
    private final Metadata metadata140;
    private final Metadata metadata141;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata139Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata139 = mbuiContext.metadataRegistry().lookup(metadata139Template);
        AddressTemplate metadata138Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata138 = mbuiContext.metadataRegistry().lookup(metadata138Template);
        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        AddressTemplate metadata140Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata140 = mbuiContext.metadataRegistry().lookup(metadata140Template);
        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        this.expressionElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-form", metadata137)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CORE_QUEUE, form))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-form", metadata138)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_QUEUE, form))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-form", metadata139)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_TOPIC, form))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-form", metadata140)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ADDRESS_SETTING, form))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-form", metadata141)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DIVERT, form))
            .build();

        coreQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-table", metadata137)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addCoreQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CORE_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("queue-address")
            .build();
        jmsQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-table", metadata138)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addJMSQueue(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("selector")
            .build();
        jmsTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-table", metadata139)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.JMS_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.JMS_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        addressSettingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-table", metadata140)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ADDRESS_SETTING), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ADDRESS_SETTING, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        divertTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-table", metadata141)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DIVERT), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DIVERT, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html410;
        HTMLElement messagingCoreQueueItemElement = section()
            .add(html410 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                .asElement())
            .add(coreQueueTable)
            .add(coreQueueForm)
            .asElement();
        expressionElements.put("html410", html410);
        navigation.addPrimary("messaging-core-queue-item", "Core Queue", "fa fa-cog", messagingCoreQueueItemElement);
        HTMLElement html413;
        HTMLElement messagingJmsQueueItemElement = section()
            .add(html413 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>${metadata138.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jmsQueueTable)
            .add(jmsQueueForm)
            .asElement();
        expressionElements.put("html413", html413);
        navigation.addPrimary("messaging-jms-queue-item", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueItemElement);
        HTMLElement html416;
        HTMLElement messagingJmsTopicItemElement = section()
            .add(html416 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>${metadata139.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jmsTopicTable)
            .add(jmsTopicForm)
            .asElement();
        expressionElements.put("html416", html416);
        navigation.addPrimary("messaging-jms-topic-item", "JMS Topic", "fa fa-arrows", messagingJmsTopicItemElement);
        HTMLElement html419;
        HTMLElement messagingAddressSettingItemElement = section()
            .add(html419 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>${metadata140.getDescription().getDescription()}</p>"))
                .asElement())
            .add(addressSettingTable)
            .add(addressSettingForm)
            .asElement();
        expressionElements.put("html419", html419);
        navigation.addPrimary("messaging-address-setting-item", "Address Setting", "fa fa-address-card-o", messagingAddressSettingItemElement);
        HTMLElement html422;
        HTMLElement messagingDivertItemElement = section()
            .add(html422 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>${metadata141.getDescription().getDescription()}</p>"))
                .asElement())
            .add(divertTable)
            .add(divertForm)
            .asElement();
        expressionElements.put("html422", html422);
        navigation.addPrimary("messaging-divert-item", "Divert", "fa fa-exchange", messagingDivertItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        TemplateUtil.replaceExpression(expressionElements.get("html410"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html413"), "${metadata138.getDescription().getDescription()}", String.valueOf(metadata138.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html416"), "${metadata139.getDescription().getDescription()}", String.valueOf(metadata139.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html419"), "${metadata140.getDescription().getDescription()}", String.valueOf(metadata140.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html422"), "${metadata141.getDescription().getDescription()}", String.valueOf(metadata141.getDescription().getDescription()));
    }
}
