package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata121;
    private final Metadata metadata122;
    private final Metadata metadata120;
    private final Metadata metadata124;
    private final Metadata metadata123;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata124Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata124 = mbuiContext.metadataRegistry().lookup(metadata124Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata120)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata120Template.resolve(mbuiContext.statementContext()), changedValues, metadata120))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata120Template.resolve(mbuiContext.statementContext()), form, metadata120))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata121)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata121Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata121);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata121Template.resolve(mbuiContext.statementContext(), name), form, metadata121);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata122)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata122Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata122);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata122Template.resolve(mbuiContext.statementContext(), name), form, metadata122);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata123)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata123Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata123);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata123Template.resolve(mbuiContext.statementContext(), name), form, metadata123);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata124)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata124Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata124);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata124Template.resolve(mbuiContext.statementContext(), name), form, metadata124);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata121)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata121Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata121Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata122)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata122Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata122Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata123)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata123Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata123Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata124)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata124Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata124Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html364;
        HTMLElement serverConfigurationItemElement = section()
            .add(html364 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata120.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverConfigurationForm)
            .asElement();
        expressionElements.put("html364", html364);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html366;
        HTMLElement serverInterfaceItemElement = section()
            .add(html366 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata121.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
            .asElement();
        expressionElements.put("html366", html366);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html369;
        HTMLElement serverJvmItemElement = section()
            .add(html369 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata122.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverJvmTable)
            .add(serverJvmForm)
            .asElement();
        expressionElements.put("html369", html369);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html372;
        HTMLElement serverPathItemElement = section()
            .add(html372 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata123.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverPathTable)
            .add(serverPathForm)
            .asElement();
        expressionElements.put("html372", html372);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html375;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html375 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata124.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
            .asElement();
        expressionElements.put("html375", html375);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html364"), "${metadata120.getDescription().getDescription()}", String.valueOf(metadata120.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html366"), "${metadata121.getDescription().getDescription()}", String.valueOf(metadata121.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html369"), "${metadata122.getDescription().getDescription()}", String.valueOf(metadata122.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html372"), "${metadata123.getDescription().getDescription()}", String.valueOf(metadata123.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html375"), "${metadata124.getDescription().getDescription()}", String.valueOf(metadata124.getDescription().getDescription()));
    }
}
