package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_BatchView extends BatchView {

    private final Metadata metadata98;
    private final Metadata metadata97;
    private final Metadata metadata94;
    private final Metadata metadata96;
    private final Metadata metadata95;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata98Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata98 = mbuiContext.metadataRegistry().lookup(metadata98Template);
        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("batch-configuration-form", metadata94)
            .onSave((form, changedValues) -> saveSingletonForm("Subsystem", metadata94Template.resolve(mbuiContext.statementContext()), changedValues, metadata94))
            .prepareReset(form -> resetSingletonForm("Subsystem", metadata94Template.resolve(mbuiContext.statementContext()), form, metadata94))
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-form", metadata96)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JDBC Job Repository", name, metadata96Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata96);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*")));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-form", metadata97)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Factory", name, metadata97Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata97);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Factory", name, metadata97Template.resolve(mbuiContext.statementContext(), name), form, metadata97);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-form", metadata98)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata98Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata98);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata98Template.resolve(mbuiContext.statementContext(), name), form, metadata98);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*")));

        inMemoryJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-in-memory-job-repo-table", metadata95)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-in-memory-job-repo-table", Ids.ADD), "In Memory Job",
                metadata95Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata95Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        jdbcJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-table", metadata96)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-jdbc-job-repo-table", Ids.ADD), "JDBC Job Repository",
                metadata96Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata96Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        threadFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-table", metadata97)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-factory-table", Ids.ADD), "Thread Factory",
                metadata97Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata97Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-table", metadata98)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata98Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata98Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html288;
        HTMLElement batchConfigurationItemElement = section()
            .add(html288 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata94.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html288", html288);
        navigation.addPrimary("batch-configuration-item", "Configuration", "pficon pficon-settings", batchConfigurationItemElement);
        HTMLElement html290;
        HTMLElement batchInMemoryJobRepoItemElement = section()
            .add(html290 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>${metadata95.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inMemoryJobRepoTable)
            .asElement();
        expressionElements.put("html290", html290);
        navigation.addPrimary("batch-in-memory-job-repo-item", "In Memory", "pficon pficon-memory", batchInMemoryJobRepoItemElement);
        HTMLElement html292;
        HTMLElement batchJdbcJobRepoItemElement = section()
            .add(html292 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>${metadata96.getDescription().getDescription()}</p>"))
                .asElement())
            .add(jdbcJobRepoTable)
            .add(jdbcJobRepoForm)
            .asElement();
        expressionElements.put("html292", html292);
        navigation.addPrimary("batch-jdbc-job-repo-item", "JDBC", "fa fa-database", batchJdbcJobRepoItemElement);
        HTMLElement html295;
        HTMLElement batchThreadFactoryItemElement = section()
            .add(html295 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>${metadata97.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadFactoryTable)
            .add(threadFactoryForm)
            .asElement();
        expressionElements.put("html295", html295);
        navigation.addPrimary("batch-thread-factory-item", "Thread Factory", "pficon pficon-service", batchThreadFactoryItemElement);
        HTMLElement html298;
        HTMLElement batchThreadPoolItemElement = section()
            .add(html298 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata98.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadPoolTable)
            .add(threadPoolForm)
            .asElement();
        expressionElements.put("html298", html298);
        navigation.addPrimary("batch-thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", batchThreadPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            jdbcJobRepoTable.bindForm(jdbcJobRepoForm);
            threadFactoryTable.bindForm(threadFactoryForm);
            threadPoolTable.bindForm(threadPoolForm);

        TemplateUtil.replaceExpression(expressionElements.get("html288"), "${metadata94.getDescription().getDescription()}", String.valueOf(metadata94.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html290"), "${metadata95.getDescription().getDescription()}", String.valueOf(metadata95.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html292"), "${metadata96.getDescription().getDescription()}", String.valueOf(metadata96.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html295"), "${metadata97.getDescription().getDescription()}", String.valueOf(metadata97.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html298"), "${metadata98.getDescription().getDescription()}", String.valueOf(metadata98.getDescription().getDescription()));
    }
}
