package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_FilterView extends FilterView {

    private final Metadata metadata29;
    private final Metadata metadata28;
    private final Metadata metadata31;
    private final Metadata metadata27;
    private final Metadata metadata33;
    private final Metadata metadata30;
    private final Metadata metadata34;
    private final Metadata metadata32;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata29Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata29 = mbuiContext.metadataRegistry().lookup(metadata29Template);
        AddressTemplate metadata28Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata28 = mbuiContext.metadataRegistry().lookup(metadata28Template);
        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata33Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata33 = mbuiContext.metadataRegistry().lookup(metadata33Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata32Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata32 = mbuiContext.metadataRegistry().lookup(metadata32Template);
        this.expressionElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-form", metadata27)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata27Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata27);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Filter", name, metadata27Template.resolve(mbuiContext.statementContext(), name), form, metadata27);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-form", metadata28)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata28Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata28);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Error Page", name, metadata28Template.resolve(mbuiContext.statementContext(), name), form, metadata28);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-form", metadata29)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata29Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata29);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Expression Filter", name, metadata29Template.resolve(mbuiContext.statementContext(), name), form, metadata29);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-form", metadata30)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-form", metadata31)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("security-realm")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 27)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata31Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata31);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Mod Cluster", name, metadata31Template.resolve(mbuiContext.statementContext(), name), form, metadata31);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-form", metadata32)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata32Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata32);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Request Limit", name, metadata32Template.resolve(mbuiContext.statementContext(), name), form, metadata32);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-form", metadata33)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .prepareReset(form -> presenter.resetResponseHeader(form))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-form", metadata34)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata34Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata34);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Rewrite", name, metadata34Template.resolve(mbuiContext.statementContext(), name), form, metadata34);
            })
            .build();

        customFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-table", metadata27)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD), "Custom Filter",
                metadata27Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata27Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        errorPageTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-table", metadata28)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD), "Error Page",
                metadata28Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata28Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("code")
            .build();
        expressionFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-table", metadata29)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD), "Expression Filter",
                metadata29Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata29Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("expression")
            .build();
        gzipTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-table", metadata30)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD), "GZip",
                metadata30Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata30Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        modClusterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-table", metadata31)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD), "Mod Cluster",
                metadata31Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata31Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("management-socket-binding")
            .build();
        requestLimitTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-table", metadata32)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD), "Request Limit",
                metadata32Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata32Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("max-concurrent-requests")
            .build();
        responseHeaderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-table", metadata33)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addResponseHeader(), Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeResponseHeader(table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-name").asString()).asString())
            .column("value", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-value").asString()).asString())
            .build();
        rewriteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-table", metadata34)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD), "Rewrite",
                metadata34Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata34Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("target")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html87;
        HTMLElement undertowCustomFilterItemElement = section()
            .add(html87 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>${metadata27.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFilterTable)
            .add(customFilterForm)
            .asElement();
        expressionElements.put("html87", html87);
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        HTMLElement html90;
        HTMLElement undertowErrorPageItemElement = section()
            .add(html90 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>${metadata28.getDescription().getDescription()}</p>"))
                .asElement())
            .add(errorPageTable)
            .add(errorPageForm)
            .asElement();
        expressionElements.put("html90", html90);
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        HTMLElement html93;
        HTMLElement undertowExpressionFilterItemElement = section()
            .add(html93 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>${metadata29.getDescription().getDescription()}</p>"))
                .asElement())
            .add(expressionFilterTable)
            .add(expressionFilterForm)
            .asElement();
        expressionElements.put("html93", html93);
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        HTMLElement html96;
        HTMLElement undertowGzipItemElement = section()
            .add(html96 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>${metadata30.getDescription().getDescription()}</p>"))
                .asElement())
            .add(gzipTable)
            .add(gzipForm)
            .asElement();
        expressionElements.put("html96", html96);
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        HTMLElement html99;
        HTMLElement undertowModClusterItemElement = section()
            .add(html99 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>${metadata31.getDescription().getDescription()}</p>"))
                .asElement())
            .add(modClusterTable)
            .add(modClusterForm)
            .asElement();
        expressionElements.put("html99", html99);
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        HTMLElement html102;
        HTMLElement undertowRequestLimitItemElement = section()
            .add(html102 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>${metadata32.getDescription().getDescription()}</p>"))
                .asElement())
            .add(requestLimitTable)
            .add(requestLimitForm)
            .asElement();
        expressionElements.put("html102", html102);
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        HTMLElement html105;
        HTMLElement undertowResponseHeaderItemElement = section()
            .add(html105 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>${metadata33.getDescription().getDescription()}</p>"))
                .asElement())
            .add(responseHeaderTable)
            .add(responseHeaderForm)
            .asElement();
        expressionElements.put("html105", html105);
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        HTMLElement html108;
        HTMLElement undertowRewriteItemElement = section()
            .add(html108 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>${metadata34.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rewriteTable)
            .add(rewriteForm)
            .asElement();
        expressionElements.put("html108", html108);
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        TemplateUtil.replaceExpression(expressionElements.get("html87"), "${metadata27.getDescription().getDescription()}", String.valueOf(metadata27.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html90"), "${metadata28.getDescription().getDescription()}", String.valueOf(metadata28.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html93"), "${metadata29.getDescription().getDescription()}", String.valueOf(metadata29.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html96"), "${metadata30.getDescription().getDescription()}", String.valueOf(metadata30.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html99"), "${metadata31.getDescription().getDescription()}", String.valueOf(metadata31.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html102"), "${metadata32.getDescription().getDescription()}", String.valueOf(metadata32.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html105"), "${metadata33.getDescription().getDescription()}", String.valueOf(metadata33.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html108"), "${metadata34.getDescription().getDescription()}", String.valueOf(metadata34.getDescription().getDescription()));
    }
}
