package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SocketBindingGroupView extends SocketBindingGroupView {

    private final Metadata metadata141;
    private final Metadata metadata140;
    private final Metadata metadata139;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SocketBindingGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata141Template = AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata140Template = AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*");
        this.metadata140 = mbuiContext.metadataRegistry().lookup(metadata140Template);
        AddressTemplate metadata139Template = AddressTemplate.of("/socket-binding-group=*");
        this.metadata139 = mbuiContext.metadataRegistry().lookup(metadata139Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-configuration-form", metadata139)
            .include("default-interface", "includes")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBindingGroup(changedValues))
            .prepareReset(form -> presenter.resetSocketBindingGroup(form))
            .build();
        outboundLocalForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-form", metadata140)
            .include("socket-binding-ref", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_LOCAL, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_LOCAL, form))
            .build();
        outboundLocalForm.getFormItem("socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        outboundRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-form", metadata141)
            .include("host", "port", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_REMOTE, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_REMOTE, form))
            .build();

        outboundLocalTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-table", metadata140)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_LOCAL), Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_LOCAL, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundRemoteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-table", metadata141)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_REMOTE), Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_REMOTE, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("host", (cell, type, row, meta) -> row.get("host").asString())
            .column("port", (cell, type, row, meta) -> row.get("port").asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html418;
        HTMLElement socketBindingGroupConfigurationItemElement = section()
            .add(html418 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Group</h1><p>${metadata139.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html418", html418);
        navigation.addPrimary("socket-binding-group-configuration-item", "Configuration", "pficon pficon-settings", socketBindingGroupConfigurationItemElement);
        HTMLElement html420;
        HTMLElement socketBindingGroupOutboundLocalItemElement = section()
            .add(html420 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Local</h1><p>${metadata140.getDescription().getDescription()}</p>"))
                .asElement())
            .add(outboundLocalTable)
            .add(outboundLocalForm)
            .asElement();
        expressionElements.put("html420", html420);
        navigation.addPrimary("socket-binding-group-outbound-local-item", "Outbound Local", "fa fa-arrow-circle-o-right", socketBindingGroupOutboundLocalItemElement);
        HTMLElement html423;
        HTMLElement socketBindingGroupOutboundRemoteItemElement = section()
            .add(html423 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Remote</h1><p>${metadata141.getDescription().getDescription()}</p>"))
                .asElement())
            .add(outboundRemoteTable)
            .add(outboundRemoteForm)
            .asElement();
        expressionElements.put("html423", html423);
        navigation.addPrimary("socket-binding-group-outbound-remote-item", "Outbound Remote", "fa fa-arrow-circle-right", socketBindingGroupOutboundRemoteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(outboundLocalTable);
        registerAttachable(outboundLocalForm);
        registerAttachable(outboundRemoteTable);
        registerAttachable(outboundRemoteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            outboundLocalTable.bindForm(outboundLocalForm);
            outboundRemoteTable.bindForm(outboundRemoteForm);

        TemplateUtil.replaceExpression(expressionElements.get("html418"), "${metadata139.getDescription().getDescription()}", String.valueOf(metadata139.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html420"), "${metadata140.getDescription().getDescription()}", String.valueOf(metadata140.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html423"), "${metadata141.getDescription().getDescription()}", String.valueOf(metadata141.getDescription().getDescription()));
    }
}
