package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata138;
    private final Metadata metadata137;
    private final Metadata metadata135;
    private final Metadata metadata133;
    private final Metadata metadata130;
    private final Metadata metadata136;
    private final Metadata metadata134;
    private final Metadata metadata131;
    private final Metadata metadata132;
    private final Metadata metadata129;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata138Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata138 = mbuiContext.metadataRegistry().lookup(metadata138Template);
        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        AddressTemplate metadata135Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata135 = mbuiContext.metadataRegistry().lookup(metadata135Template);
        AddressTemplate metadata133Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata133 = mbuiContext.metadataRegistry().lookup(metadata133Template);
        AddressTemplate metadata130Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata130 = mbuiContext.metadataRegistry().lookup(metadata130Template);
        AddressTemplate metadata136Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata136 = mbuiContext.metadataRegistry().lookup(metadata136Template);
        AddressTemplate metadata134Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata134 = mbuiContext.metadataRegistry().lookup(metadata134Template);
        AddressTemplate metadata131Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata131 = mbuiContext.metadataRegistry().lookup(metadata131Template);
        AddressTemplate metadata132Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata132 = mbuiContext.metadataRegistry().lookup(metadata132Template);
        AddressTemplate metadata129Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata129 = mbuiContext.metadataRegistry().lookup(metadata129Template);
        this.expressionElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-form", metadata129)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ACCEPTOR, form))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-form", metadata130)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_ACCEPTOR, form))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-form", metadata131)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_ACCEPTOR, form))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-form", metadata132)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_ACCEPTOR, form))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-form", metadata133)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR, form))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-form", metadata134)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-form", metadata135)
            .include("endpoint", "server-name", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_CONNECTOR, form))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-form", metadata136)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_CONNECTOR, form))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-form", metadata137)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR_SERVICE, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-form", metadata138)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTION_FACTORY, form))
            .build();

        acceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-table", metadata129)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-table", metadata130)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-table", metadata131)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-table", metadata132)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-table", metadata133)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-table", metadata134)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-table", metadata135)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-table", metadata136)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorServiceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-table", metadata137)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR_SERVICE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-table", metadata138)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-item", "Acceptor", "fa fa-sign-in");
        HTMLElement html387;
        HTMLElement messagingAcceptorItemElement = section()
            .add(html387 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>${metadata129.getDescription().getDescription()}</p>"))
                .asElement())
            .add(acceptorTable)
            .add(acceptorForm)
            .asElement();
        expressionElements.put("html387", html387);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-acceptor-item", "Generic", messagingAcceptorItemElement);
        HTMLElement html390;
        HTMLElement messagingInVmAcceptorItemElement = section()
            .add(html390 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>${metadata130.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inVmAcceptorTable)
            .add(inVmAcceptorForm)
            .asElement();
        expressionElements.put("html390", html390);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-in-vm-acceptor-item", "In VM", messagingInVmAcceptorItemElement);
        HTMLElement html393;
        HTMLElement messagingHttpAcceptorItemElement = section()
            .add(html393 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>${metadata131.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpAcceptorTable)
            .add(httpAcceptorForm)
            .asElement();
        expressionElements.put("html393", html393);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-http-acceptor-item", "HTTP", messagingHttpAcceptorItemElement);
        HTMLElement html396;
        HTMLElement messagingRemoteAcceptorItemElement = section()
            .add(html396 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>${metadata132.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteAcceptorTable)
            .add(remoteAcceptorForm)
            .asElement();
        expressionElements.put("html396", html396);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-remote-acceptor-item", "Remote", messagingRemoteAcceptorItemElement);
        navigation.addPrimary("messaging-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html399;
        HTMLElement messagingConnectorItemElement = section()
            .add(html399 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata133.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorTable)
            .add(connectorForm)
            .asElement();
        expressionElements.put("html399", html399);
        navigation.addSecondary("messaging-connector-group-item", "messaging-connector-item", "Generic", messagingConnectorItemElement);
        HTMLElement html402;
        HTMLElement messagingInVmConnectorItemElement = section()
            .add(html402 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata134.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
            .asElement();
        expressionElements.put("html402", html402);
        navigation.addSecondary("messaging-connector-group-item", "messaging-in-vm-connector-item", "In VM", messagingInVmConnectorItemElement);
        HTMLElement html405;
        HTMLElement messagingHttpConnectorItemElement = section()
            .add(html405 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata135.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
            .asElement();
        expressionElements.put("html405", html405);
        navigation.addSecondary("messaging-connector-group-item", "messaging-http-connector-item", "HTTP", messagingHttpConnectorItemElement);
        HTMLElement html408;
        HTMLElement messagingRemoteConnectorItemElement = section()
            .add(html408 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata136.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
            .asElement();
        expressionElements.put("html408", html408);
        navigation.addSecondary("messaging-connector-group-item", "messaging-remote-connector-item", "Remote", messagingRemoteConnectorItemElement);
        HTMLElement html411;
        HTMLElement messagingConnectorServiceItemElement = section()
            .add(html411 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorServiceTable)
            .add(connectorServiceForm)
            .asElement();
        expressionElements.put("html411", html411);
        navigation.addPrimary("messaging-connector-service-item", "Connector Service", "pficon pficon-service", messagingConnectorServiceItemElement);
        HTMLElement html414;
        HTMLElement messagingConnectionFactoryItemElement = section()
            .add(html414 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata138.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
            .asElement();
        expressionElements.put("html414", html414);
        navigation.addPrimary("messaging-connection-factory-item", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);

        TemplateUtil.replaceExpression(expressionElements.get("html387"), "${metadata129.getDescription().getDescription()}", String.valueOf(metadata129.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html390"), "${metadata130.getDescription().getDescription()}", String.valueOf(metadata130.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html393"), "${metadata131.getDescription().getDescription()}", String.valueOf(metadata131.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html396"), "${metadata132.getDescription().getDescription()}", String.valueOf(metadata132.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html399"), "${metadata133.getDescription().getDescription()}", String.valueOf(metadata133.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html402"), "${metadata134.getDescription().getDescription()}", String.valueOf(metadata134.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html405"), "${metadata135.getDescription().getDescription()}", String.valueOf(metadata135.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html408"), "${metadata136.getDescription().getDescription()}", String.valueOf(metadata136.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html411"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html414"), "${metadata138.getDescription().getDescription()}", String.valueOf(metadata138.getDescription().getDescription()));
    }
}
