package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemoteActiveMQView extends RemoteActiveMQView {

    private final Metadata metadata125;
    private final Metadata metadata123;
    private final Metadata metadata121;
    private final Metadata metadata127;
    private final Metadata metadata122;
    private final Metadata metadata124;
    private final Metadata metadata120;
    private final Metadata metadata126;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemoteActiveMQView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata125Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connection-factory=*");
        this.metadata125 = mbuiContext.metadataRegistry().lookup(metadata125Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/remote-connector=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/in-vm-connector=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata127Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-topic=*");
        this.metadata127 = mbuiContext.metadataRegistry().lookup(metadata127Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/http-connector=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata124Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/discovery-group=*");
        this.metadata124 = mbuiContext.metadataRegistry().lookup(metadata124Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connector=*");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata126Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-queue=*");
        this.metadata126 = mbuiContext.metadataRegistry().lookup(metadata126Template);
        this.expressionElements = new HashMap<>();

        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-form", metadata120)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTOR, form))
            .build();
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-form", metadata121)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-form", metadata122)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.HTTP_CONNECTOR, form))
            .build();
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-form", metadata123)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form))
            .build();
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-form", metadata124)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.DISCOVERY_GROUP, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-form", metadata125)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTION_FACTORY, form))
            .build();
        externalQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-form", metadata126)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form))
            .build();
        externalTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-form", metadata127)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form))
            .build();

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-table", metadata120)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-table", metadata121)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-table", metadata122)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-table", metadata123)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemoteConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-discovery-group-table", metadata124)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-table", metadata125)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addConnectionFactory(RemoteActiveMQSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-table", metadata126)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-table", metadata127)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("msg-remote-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html359;
        HTMLElement msgRemoteConnectorItemElement = section()
            .add(html359 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata120.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorTable)
            .add(connectorForm)
            .asElement();
        expressionElements.put("html359", html359);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-connector-item", "Generic", msgRemoteConnectorItemElement);
        HTMLElement html362;
        HTMLElement msgRemoteInVmConnectorItemElement = section()
            .add(html362 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata121.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
            .asElement();
        expressionElements.put("html362", html362);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-in-vm-connector-item", "In VM", msgRemoteInVmConnectorItemElement);
        HTMLElement html365;
        HTMLElement msgRemoteHttpConnectorItemElement = section()
            .add(html365 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata122.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
            .asElement();
        expressionElements.put("html365", html365);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-http-connector-item", "HTTP", msgRemoteHttpConnectorItemElement);
        HTMLElement html368;
        HTMLElement msgRemoteRemoteConnectorItemElement = section()
            .add(html368 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata123.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
            .asElement();
        expressionElements.put("html368", html368);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-remote-connector-item", "Remote", msgRemoteRemoteConnectorItemElement);
        HTMLElement html371;
        HTMLElement msgRemoteDiscoveryGroupItemElement = section()
            .add(html371 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>${metadata124.getDescription().getDescription()}</p>"))
                .asElement())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
            .asElement();
        expressionElements.put("html371", html371);
        navigation.addPrimary("msg-remote-discovery-group-item", "Discovery Group", "pficon pficon-service", msgRemoteDiscoveryGroupItemElement);
        HTMLElement html374;
        HTMLElement msgRemoteConnectionFactoryItemElement = section()
            .add(html374 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata125.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
            .asElement();
        expressionElements.put("html374", html374);
        navigation.addPrimary("msg-remote-connection-factory-item", "Connection Factory", "fa fa-cubes", msgRemoteConnectionFactoryItemElement);
        HTMLElement html377;
        HTMLElement msgRemoteExternalQueueItemElement = section()
            .add(html377 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Queue</h1><p>${metadata126.getDescription().getDescription()}</p>"))
                .asElement())
            .add(externalQueueTable)
            .add(externalQueueForm)
            .asElement();
        expressionElements.put("html377", html377);
        navigation.addPrimary("msg-remote-external-queue-item", "External JMS Queue", "fa fa-long-arrow-right", msgRemoteExternalQueueItemElement);
        HTMLElement html380;
        HTMLElement msgRemoteExternalTopicItemElement = section()
            .add(html380 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Topic</h1><p>${metadata127.getDescription().getDescription()}</p>"))
                .asElement())
            .add(externalTopicTable)
            .add(externalTopicForm)
            .asElement();
        expressionElements.put("html380", html380);
        navigation.addPrimary("msg-remote-external-topic-item", "External JMS Topic", "fa fa-arrows", msgRemoteExternalTopicItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(externalQueueTable);
        registerAttachable(externalQueueForm);
        registerAttachable(externalTopicTable);
        registerAttachable(externalTopicForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            externalQueueTable.bindForm(externalQueueForm);
            externalTopicTable.bindForm(externalTopicForm);

        TemplateUtil.replaceExpression(expressionElements.get("html359"), "${metadata120.getDescription().getDescription()}", String.valueOf(metadata120.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html362"), "${metadata121.getDescription().getDescription()}", String.valueOf(metadata121.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html365"), "${metadata122.getDescription().getDescription()}", String.valueOf(metadata122.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html368"), "${metadata123.getDescription().getDescription()}", String.valueOf(metadata123.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html371"), "${metadata124.getDescription().getDescription()}", String.valueOf(metadata124.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html374"), "${metadata125.getDescription().getDescription()}", String.valueOf(metadata125.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html377"), "${metadata126.getDescription().getDescription()}", String.valueOf(metadata126.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html380"), "${metadata127.getDescription().getDescription()}", String.valueOf(metadata127.getDescription().getDescription()));
    }
}
