package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata62;
    private final Metadata metadata65;
    private final Metadata metadata63;
    private final Metadata metadata61;
    private final Metadata metadata66;
    private final Metadata metadata64;
    private final Metadata metadata60;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata65Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata65 = mbuiContext.metadataRegistry().lookup(metadata65Template);
        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata66Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata66 = mbuiContext.metadataRegistry().lookup(metadata66Template);
        AddressTemplate metadata64Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata64 = mbuiContext.metadataRegistry().lookup(metadata64Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata60)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata60Template.resolve(statementContext()), changedValues, metadata60))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata60Template.resolve(statementContext()), form, metadata60))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata61)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata61Template.resolve(statementContext(), name), changedValues, metadata61);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata61Template.resolve(statementContext(), name), form, metadata61);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata62)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata62Template.resolve(statementContext(), name), changedValues, metadata62);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata62Template.resolve(statementContext(), name), form, metadata62);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata63)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata63Template.resolve(statementContext(), name), changedValues, metadata63);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata63Template.resolve(statementContext(), name), form, metadata63);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata64)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata64Template.resolve(statementContext(), name), changedValues, metadata64);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata64Template.resolve(statementContext(), name), form, metadata64);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata65)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata65Template.resolve(statementContext(), name), changedValues, metadata65);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata65Template.resolve(statementContext(), name), form, metadata65);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata66)
            .singleton(
                () -> new Operation.Builder(metadata66Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata66Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata66Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata66Template.resolve(statementContext()), changedValues, metadata66))
            .prepareReset(form -> resetSingletonForm("Vault", metadata66Template.resolve(statementContext()), form, metadata66))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata61)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata61Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata61Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata62)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata62Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata62Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata63)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata63Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata63Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata64)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata64Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata64Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata65)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata65Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata65Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html181;
        HTMLElement securityConfigurationItemElement = section()
            .add(html181 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html181", html181);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html183;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html183 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                .asElement())
            .add(keyManagerTable)
            .add(keyManagerForm)
            .asElement();
        expressionElements.put("html183", html183);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html186;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html186 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata62.getDescription().getDescription()}</p>"))
                .asElement())
            .add(keyStoreTable)
            .add(keyStoreForm)
            .asElement();
        expressionElements.put("html186", html186);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html189;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html189 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata63.getDescription().getDescription()}</p>"))
                .asElement())
            .add(realmTable)
            .add(realmForm)
            .asElement();
        expressionElements.put("html189", html189);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html192;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html192 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata64.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustManagerTable)
            .add(trustManagerForm)
            .asElement();
        expressionElements.put("html192", html192);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html195;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html195 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata65.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustStoreTable)
            .add(trustStoreForm)
            .asElement();
        expressionElements.put("html195", html195);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html198;
        HTMLElement securityVaultItemElement = section()
            .add(html198 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata66.getDescription().getDescription()}</p>"))
                .asElement())
            .add(vaultForm)
            .asElement();
        expressionElements.put("html198", html198);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceExpression(expressionElements.get("html181"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html183"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html186"), "${metadata62.getDescription().getDescription()}", String.valueOf(metadata62.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html189"), "${metadata63.getDescription().getDescription()}", String.valueOf(metadata63.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html192"), "${metadata64.getDescription().getDescription()}", String.valueOf(metadata64.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html195"), "${metadata65.getDescription().getDescription()}", String.valueOf(metadata65.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html198"), "${metadata66.getDescription().getDescription()}", String.valueOf(metadata66.getDescription().getDescription()));
    }
}
