package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HostView extends HostView {

    private final Metadata metadata80;
    private final Metadata metadata84;
    private final Metadata metadata82;
    private final Metadata metadata83;
    private final Metadata metadata81;
    private final Metadata metadata85;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata80Template = AddressTemplate.of("/{selected.host}");
        this.metadata80 = mbuiContext.metadataRegistry().lookup(metadata80Template);
        AddressTemplate metadata84Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata84 = mbuiContext.metadataRegistry().lookup(metadata84Template);
        AddressTemplate metadata82Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata82 = mbuiContext.metadataRegistry().lookup(metadata82Template);
        AddressTemplate metadata83Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata83 = mbuiContext.metadataRegistry().lookup(metadata83Template);
        AddressTemplate metadata81Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata81 = mbuiContext.metadataRegistry().lookup(metadata81Template);
        AddressTemplate metadata85Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata85 = mbuiContext.metadataRegistry().lookup(metadata85Template);
        this.expressionElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata80)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata80Template.resolve(statementContext()), form, metadata80))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata81)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata81Template.resolve(statementContext(), name), changedValues, metadata81);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata81Template.resolve(statementContext(), name), form, metadata81);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata82)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata82Template.resolve(statementContext(), name), changedValues, metadata82);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata82Template.resolve(statementContext(), name), form, metadata82);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata83)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata83Template.resolve(statementContext(), name), changedValues, metadata83);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata83Template.resolve(statementContext(), name), form, metadata83);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata84)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata84Template.resolve(statementContext(), name), changedValues, metadata84);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata84Template.resolve(statementContext(), name), form, metadata84);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata85)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata85Template.resolve(statementContext(), name), changedValues, metadata85);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata85Template.resolve(statementContext(), name), form, metadata85);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata81)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD), "Interface",
                metadata81Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata81Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata82)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD), "JVM",
                metadata82Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata82Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata83)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD), "Path",
                metadata83Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata83Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata84)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD), "Socket Binding Group",
                metadata84Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata84Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata85)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD), "System Property",
                metadata85Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata85Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html240;
        HTMLElement hostConfigurationItemElement = section()
            .add(html240 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>${metadata80.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostConfigurationForm)
            .asElement();
        expressionElements.put("html240", html240);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html242;
        HTMLElement hostInterfaceItemElement = section()
            .add(html242 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata81.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
            .asElement();
        expressionElements.put("html242", html242);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html245;
        HTMLElement hostJvmItemElement = section()
            .add(html245 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata82.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostJvmTable)
            .add(hostJvmForm)
            .asElement();
        expressionElements.put("html245", html245);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html248;
        HTMLElement hostPathItemElement = section()
            .add(html248 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata83.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostPathTable)
            .add(hostPathForm)
            .asElement();
        expressionElements.put("html248", html248);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html251;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html251 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>${metadata84.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
            .asElement();
        expressionElements.put("html251", html251);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html254;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html254 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata85.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
            .asElement();
        expressionElements.put("html254", html254);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html240"), "${metadata80.getDescription().getDescription()}", String.valueOf(metadata80.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html242"), "${metadata81.getDescription().getDescription()}", String.valueOf(metadata81.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html245"), "${metadata82.getDescription().getDescription()}", String.valueOf(metadata82.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html248"), "${metadata83.getDescription().getDescription()}", String.valueOf(metadata83.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html251"), "${metadata84.getDescription().getDescription()}", String.valueOf(metadata84.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html254"), "${metadata85.getDescription().getDescription()}", String.valueOf(metadata85.getDescription().getDescription()));
    }
}
