package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata154;
    private final Metadata metadata151;
    private final Metadata metadata150;
    private final Metadata metadata143;
    private final Metadata metadata153;
    private final Metadata metadata152;
    private final Metadata metadata156;
    private final Metadata metadata144;
    private final Metadata metadata147;
    private final Metadata metadata146;
    private final Metadata metadata145;
    private final Metadata metadata148;
    private final Metadata metadata149;
    private final Metadata metadata155;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata154Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata154 = mbuiContext.metadataRegistry().lookup(metadata154Template);
        AddressTemplate metadata151Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata151 = mbuiContext.metadataRegistry().lookup(metadata151Template);
        AddressTemplate metadata150Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata150 = mbuiContext.metadataRegistry().lookup(metadata150Template);
        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata153Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*");
        this.metadata153 = mbuiContext.metadataRegistry().lookup(metadata153Template);
        AddressTemplate metadata152Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata152 = mbuiContext.metadataRegistry().lookup(metadata152Template);
        AddressTemplate metadata156Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata156 = mbuiContext.metadataRegistry().lookup(metadata156Template);
        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata147Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata147 = mbuiContext.metadataRegistry().lookup(metadata147Template);
        AddressTemplate metadata146Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata146 = mbuiContext.metadataRegistry().lookup(metadata146Template);
        AddressTemplate metadata145Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata145 = mbuiContext.metadataRegistry().lookup(metadata145Template);
        AddressTemplate metadata148Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata148 = mbuiContext.metadataRegistry().lookup(metadata148Template);
        AddressTemplate metadata149Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata149 = mbuiContext.metadataRegistry().lookup(metadata149Template);
        AddressTemplate metadata155Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata155 = mbuiContext.metadataRegistry().lookup(metadata155Template);
        this.expressionElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata143)
            .onSave((form, changedValues) -> saveSingletonForm("Logging Configuration", metadata143Template.resolve(statementContext()), changedValues, metadata143))
            .prepareReset(form -> resetSingletonForm("Logging Configuration", metadata143Template.resolve(statementContext()), form, metadata143))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata144)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Root Logger", metadata144Template.resolve(statementContext()), changedValues, metadata144))
            .prepareReset(form -> resetSingletonForm("Root Logger", metadata144Template.resolve(statementContext()), form, metadata144))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-form", metadata145)
            .include("category", "filter-spec", "handlers", "level", "use-parent-handlers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Category", name, metadata145Template.resolve(statementContext(), name), changedValues, metadata145);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Category", name, metadata145Template.resolve(statementContext(), name), form, metadata145);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-form", metadata147)
            .include("autoflush", "enabled", "encoding", "filter-spec", "formatter", "level", "named-formatter", "target")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Console Handler", name, metadata147Template.resolve(statementContext(), name), changedValues, metadata147);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Console Handler", name, metadata147Template.resolve(statementContext(), name), form, metadata147);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-form", metadata149)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("named-formatter")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata149Template.resolve(statementContext(), name), changedValues, metadata149);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata149Template.resolve(statementContext(), name), form, metadata149);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-form", metadata150)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("named-formatter")
            .include("suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Rotating File Handler", name, metadata150Template.resolve(statementContext(), name), changedValues, metadata150);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Rotating File Handler", name, metadata150Template.resolve(statementContext(), name), form, metadata150);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata151)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("max-backup-index")
            .include("named-formatter")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Size Rotating File Handler", name, metadata151Template.resolve(statementContext(), name), changedValues, metadata151);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Size Rotating File Handler", name, metadata151Template.resolve(statementContext(), name), form, metadata151);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-form", metadata152)
            .include("append")
            .include("autoflush")
            .include("enabled")
            .include("encoding")
            .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
            .include("filter-spec")
            .include("formatter")
            .include("level")
            .include("max-backup-index")
            .include("named-formatter")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Size Rotating File Handler", name, metadata152Template.resolve(statementContext(), name), changedValues, metadata152);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Size Rotating File Handler", name, metadata152Template.resolve(statementContext(), name), form, metadata152);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-form", metadata146)
            .include("filter-spec", "level", "overflow-action", "queue-length", "subhandlers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Async Handler", name, metadata146Template.resolve(statementContext(), name), changedValues, metadata146);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Async Handler", name, metadata146Template.resolve(statementContext(), name), form, metadata146);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-form", metadata148)
            .include("class", "enabled", "encoding", "filter-spec", "formatter", "level", "module", "named-formatter", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Handler", name, metadata148Template.resolve(statementContext(), name), changedValues, metadata148);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Handler", name, metadata148Template.resolve(statementContext(), name), form, metadata148);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), customHandlerFormTemplates));
        socketHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-socket-form", metadata153)
            .include("autoflush", "block-on-reconnect", "enabled", "encoding", "filter-spec", "level", "named-formatter", "outbound-socket-binding-ref", "protocol", "ssl-context")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Handler", name, metadata153Template.resolve(statementContext(), name), changedValues, metadata153);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Handler", name, metadata153Template.resolve(statementContext(), name), form, metadata153);
            })
            .build();
        List<AddressTemplate> socketHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        socketHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), socketHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-form", metadata154)
            .include("app-name", "enabled", "facility", "hostname", "level", "port", "server-address", "syslog-format")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Syslog Handler", name, metadata154Template.resolve(statementContext(), name), changedValues, metadata154);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Syslog Handler", name, metadata154Template.resolve(statementContext(), name), form, metadata154);
            })
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-form", metadata155)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Formatter", name, metadata155Template.resolve(statementContext(), name), changedValues, metadata155);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Formatter", name, metadata155Template.resolve(statementContext(), name), form, metadata155);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-form", metadata156)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Pattern Formatter", name, metadata156Template.resolve(statementContext(), name), changedValues, metadata156);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Pattern Formatter", name, metadata156Template.resolve(statementContext(), name), form, metadata156);
            })
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-table", metadata145)
            .button(mbuiContext.tableButtonFactory().add(metadata145Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-category-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata145,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata145Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Category", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), loggerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata145Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-table", metadata147)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-console-table", Ids.ADD), "Console Handler",
                metadata147Template, asList("level", "formatter", "target"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata147Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-table", metadata149)
            .button(mbuiContext.tableButtonFactory().add(metadata149Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-file-table", Ids.ADD),
                    metadata149)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata149Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata149Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-table", metadata150)
            .button(mbuiContext.tableButtonFactory().add(metadata150Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-rotating-file-table", Ids.ADD),
                    metadata150)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .include("suffix")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata150Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Periodic Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata150Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-table", metadata151)
            .button(mbuiContext.tableButtonFactory().add(metadata151Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-size-rotating-file-table", Ids.ADD),
                    metadata151)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .include("max-backup-index")
                    .include("rotate-size")
                    .include("suffix")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata151Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Periodic Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata151Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-table", metadata152)
            .button(mbuiContext.tableButtonFactory().add(metadata152Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-size-rotating-file-table", Ids.ADD),
                    metadata152)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("file", true))
                    .include("formatter")
                    .include("level")
                    .include("max-backup-index")
                    .include("rotate-size")
                    .include("suffix")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata152Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata152Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-table", metadata146)
            .button(mbuiContext.tableButtonFactory().add(metadata146Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-async-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata146,
                    asList("level", "overflow-action", "queue-length", "subhandlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata146Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Async Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), asyncHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata146Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-table", metadata148)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-custom-table", Ids.ADD), "Custom Handler",
                metadata148Template, asList("class", "formatter", "level", "module"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata148Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        socketHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-socket-table", metadata153)
            .button(mbuiContext.tableButtonFactory().add(metadata153Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-socket-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Socket Handler"),
                    metadata153,
                    asList("named-formatter", "outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata153Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Socket Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> socketHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
                dialog.getForm().getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), socketHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Socket Handler", metadata153Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-table", metadata154)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-syslog-table", Ids.ADD), "Syslog Handler",
                metadata154Template, asList("app-name", "facility", "hostname", "level", "port", "server-address", "syslog-format"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata154Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-table", metadata155)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-custom-table", Ids.ADD), "Custom Formatter",
                metadata155Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata155Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-table", metadata156)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-pattern-table", Ids.ADD), "Pattern Formatter",
                metadata156Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata156Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html430;
        HTMLElement loggingConfigItemElement = section()
            .add(html430 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata143.getDescription().getDescription()}</p>"))
                            .get())
            .add(loggingConfigForm)
                    .get();
        expressionElements.put("html430", html430);
        navigation.addPrimary("logging-config-item", "Configuration", "pficon pficon-settings", loggingConfigItemElement);
        HTMLElement html432;
        HTMLElement loggingRootLoggerItemElement = section()
            .add(html432 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">${metadata144.getDescription().getDescription()}</p>"))
                            .get())
            .add(rootLoggerForm)
                    .get();
        expressionElements.put("html432", html432);
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        HTMLElement html434;
        HTMLElement loggingCategoryItemElement = section()
            .add(html434 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata145.getDescription().getDescription()}</p>"))
                            .get())
            .add(loggerTable)
            .add(loggerForm)
                    .get();
        expressionElements.put("html434", html434);
        navigation.addPrimary("logging-category-item", "Categories", "pficon pficon-repository", loggingCategoryItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html437;
        HTMLElement loggingHandlerAsyncItemElement = section()
            .add(html437 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata146.getDescription().getDescription()}</p>"))
                                    .get())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
                            .get();
        expressionElements.put("html437", html437);
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        HTMLElement html440;
        HTMLElement loggingHandlerConsoleItemElement = section()
            .add(html440 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata147.getDescription().getDescription()}</p>"))
                                    .get())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
                            .get();
        expressionElements.put("html440", html440);
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        HTMLElement html443;
        HTMLElement loggingHandlerCustomItemElement = section()
            .add(html443 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata148.getDescription().getDescription()}</p>"))
                                    .get())
            .add(customHandlerTable)
            .add(customHandlerForm)
                            .get();
        expressionElements.put("html443", html443);
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        HTMLElement html446;
        HTMLElement loggingHandlerFileItemElement = section()
            .add(html446 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata149.getDescription().getDescription()}</p>"))
                                    .get())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
                            .get();
        expressionElements.put("html446", html446);
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        HTMLElement html449;
        HTMLElement loggingHandlerPeriodicRotatingFileItemElement = section()
            .add(html449 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata150.getDescription().getDescription()}</p>"))
                                    .get())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
                            .get();
        expressionElements.put("html449", html449);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        HTMLElement html452;
        HTMLElement loggingHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html452 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata151.getDescription().getDescription()}</p>"))
                                    .get())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
                            .get();
        expressionElements.put("html452", html452);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html455;
        HTMLElement loggingHandlerSizeRotatingFileItemElement = section()
            .add(html455 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata152.getDescription().getDescription()}</p>"))
                                    .get())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
                            .get();
        expressionElements.put("html455", html455);
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        HTMLElement html458;
        HTMLElement loggingHandlerSocketItemElement = section()
            .add(html458 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Handler</h1><p>${metadata153.getDescription().getDescription()}</p>"))
                                    .get())
            .add(socketHandlerTable)
            .add(socketHandlerForm)
                            .get();
        expressionElements.put("html458", html458);
        navigation.addSecondary("logging-handler-item", "logging-handler-socket-item", "Socket Handler", loggingHandlerSocketItemElement);
        HTMLElement html461;
        HTMLElement loggingHandlerSyslogItemElement = section()
            .add(html461 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata154.getDescription().getDescription()}</p>"))
                                    .get())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
                            .get();
        expressionElements.put("html461", html461);
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html464;
        HTMLElement loggingFormatterCustomItemElement = section()
            .add(html464 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata155.getDescription().getDescription()}</p>"))
                                    .get())
            .add(customFormatterTable)
            .add(customFormatterForm)
                            .get();
        expressionElements.put("html464", html464);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);
        HTMLElement html467;
        HTMLElement loggingFormatterPatternItemElement = section()
            .add(html467 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata156.getDescription().getDescription()}</p>"))
                                    .get())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
                            .get();
        expressionElements.put("html467", html467);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .get();

        registerAttachable(navigation);
        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(socketHandlerTable);
        registerAttachable(socketHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            socketHandlerTable.bindForm(socketHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceExpression(expressionElements.get("html430"), "${metadata143.getDescription().getDescription()}", String.valueOf(metadata143.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html432"), "${metadata144.getDescription().getDescription()}", String.valueOf(metadata144.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html434"), "${metadata145.getDescription().getDescription()}", String.valueOf(metadata145.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html437"), "${metadata146.getDescription().getDescription()}", String.valueOf(metadata146.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html440"), "${metadata147.getDescription().getDescription()}", String.valueOf(metadata147.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html443"), "${metadata148.getDescription().getDescription()}", String.valueOf(metadata148.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html446"), "${metadata149.getDescription().getDescription()}", String.valueOf(metadata149.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html449"), "${metadata150.getDescription().getDescription()}", String.valueOf(metadata150.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html452"), "${metadata151.getDescription().getDescription()}", String.valueOf(metadata151.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html455"), "${metadata152.getDescription().getDescription()}", String.valueOf(metadata152.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html458"), "${metadata153.getDescription().getDescription()}", String.valueOf(metadata153.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html461"), "${metadata154.getDescription().getDescription()}", String.valueOf(metadata154.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html464"), "${metadata155.getDescription().getDescription()}", String.valueOf(metadata155.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html467"), "${metadata156.getDescription().getDescription()}", String.valueOf(metadata156.getDescription().getDescription()));
    }
}
