package org.jboss.hal.client.configuration.subsystem.distributableweb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DistributableWebView extends DistributableWebView {

    private final Metadata metadata99;
    private final Metadata metadata102;
    private final Metadata metadata100;
    private final Metadata metadata101;
    private final Metadata metadata103;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DistributableWebView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/infinispan-session-management=*");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/hotrod-session-management=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/hotrod-single-sign-on-management=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/infinispan-single-sign-on-management=*");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("dw-configuration-form", metadata99)
            .onSave((form, changedValues) -> saveSingletonForm("Distributable Web", metadata99Template.resolve(statementContext()), changedValues, metadata99))
            .prepareReset(form -> resetSingletonForm("Distributable Web", metadata99Template.resolve(statementContext()), form, metadata99))
            .build();
        hotRodSessionManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-session-management-form", metadata100)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Hotrod Session Management", name, metadata100Template.resolve(statementContext(), name), changedValues, metadata100);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Hotrod Session Management", name, metadata100Template.resolve(statementContext(), name), form, metadata100);
            })
            .build();
        hotRodSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-form", metadata101)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Hotrod Single Sign On Management", name, metadata101Template.resolve(statementContext(), name), changedValues, metadata101);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Hotrod Single Sign On Management", name, metadata101Template.resolve(statementContext(), name), form, metadata101);
            })
            .build();
        infinispanSessionManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-session-management-form", metadata102)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Infinispan Session Management", name, metadata102Template.resolve(statementContext(), name), changedValues, metadata102);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Infinispan Session Management", name, metadata102Template.resolve(statementContext(), name), form, metadata102);
            })
            .build();
        infinispanSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-form", metadata103)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Infinispan Single Sign On Management", name, metadata103Template.resolve(statementContext(), name), changedValues, metadata103);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Infinispan Single Sign On Management", name, metadata103Template.resolve(statementContext(), name), form, metadata103);
            })
            .build();

        hotRodSessionManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-session-management-table", metadata100)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-hotrod-session-management-table", Ids.ADD), "Hotrod Session Management",
                metadata100Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Hotrod Session Management", metadata100Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hotRodSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-table", metadata101)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-hotrod-sso-management-table", Ids.ADD), "Hotrod Single Sign On Management",
                metadata101Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Hotrod Single Sign On Management", metadata101Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        infinispanSessionManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-session-management-table", metadata102)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-infinispan-session-management-table", Ids.ADD), "Infinispan Session Management",
                metadata102Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Infinispan Session Management", metadata102Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        infinispanSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-table", metadata103)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-infinispan-sso-management-table", Ids.ADD), "Infinispan Single Sign On Management",
                metadata103Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Infinispan Single Sign On Management", metadata103Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html299;
        HTMLElement dwConfigurationItemElement = section()
            .add(html299 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Distributable Web</h1><p>${metadata99.getDescription().getDescription()}</p>"))
                            .get())
            .add(configurationForm)
                    .get();
        expressionElements.put("html299", html299);
        navigation.addPrimary("dw-configuration-item", "Configuration", "pficon pficon-settings", dwConfigurationItemElement);
        HTMLElement html301;
        HTMLElement dwHotrodSessionManagementItemElement = section()
            .add(html301 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HotRod Session Management</h1><p>${metadata100.getDescription().getDescription()}</p>"))
                            .get())
            .add(hotRodSessionManagementTable)
            .add(hotRodSessionManagementForm)
                    .get();
        expressionElements.put("html301", html301);
        navigation.addPrimary("dw-hotrod-session-management-item", "HotRod Session", "pficon pficon-users", dwHotrodSessionManagementItemElement);
        HTMLElement html304;
        HTMLElement dwHotrodSsoManagementItemElement = section()
            .add(html304 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HotRod SSO Management</h1><p>${metadata101.getDescription().getDescription()}</p>"))
                            .get())
            .add(hotRodSSOManagementTable)
            .add(hotRodSSOManagementForm)
                    .get();
        expressionElements.put("html304", html304);
        navigation.addPrimary("dw-hotrod-sso-management-item", "HotRod SSO", "fa fa-lock", dwHotrodSsoManagementItemElement);
        HTMLElement html307;
        HTMLElement dwInfinispanSessionManagementItemElement = section()
            .add(html307 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Infinispan Session Management</h1><p>${metadata102.getDescription().getDescription()}</p>"))
                            .get())
            .add(infinispanSessionManagementTable)
            .add(infinispanSessionManagementForm)
                    .get();
        expressionElements.put("html307", html307);
        navigation.addPrimary("dw-infinispan-session-management-item", "Infinispan Session", "pficon pficon-users", dwInfinispanSessionManagementItemElement);
        HTMLElement html310;
        HTMLElement dwInfinispanSsoManagementItemElement = section()
            .add(html310 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Infinispan SSO Management</h1><p>${metadata103.getDescription().getDescription()}</p>"))
                            .get())
            .add(infinispanSSOManagementTable)
            .add(infinispanSSOManagementForm)
                    .get();
        expressionElements.put("html310", html310);
        navigation.addPrimary("dw-infinispan-sso-management-item", "Infinispan SSO", "fa fa-lock", dwInfinispanSsoManagementItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .get();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(hotRodSessionManagementTable);
        registerAttachable(hotRodSessionManagementForm);
        registerAttachable(hotRodSSOManagementTable);
        registerAttachable(hotRodSSOManagementForm);
        registerAttachable(infinispanSessionManagementTable);
        registerAttachable(infinispanSessionManagementForm);
        registerAttachable(infinispanSSOManagementTable);
        registerAttachable(infinispanSSOManagementForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hotRodSessionManagementTable.bindForm(hotRodSessionManagementForm);
            hotRodSSOManagementTable.bindForm(hotRodSSOManagementForm);
            infinispanSessionManagementTable.bindForm(infinispanSessionManagementForm);
            infinispanSSOManagementTable.bindForm(infinispanSSOManagementForm);

        TemplateUtil.replaceExpression(expressionElements.get("html299"), "${metadata99.getDescription().getDescription()}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html301"), "${metadata100.getDescription().getDescription()}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html304"), "${metadata101.getDescription().getDescription()}", String.valueOf(metadata101.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html307"), "${metadata102.getDescription().getDescription()}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html310"), "${metadata103.getDescription().getDescription()}", String.valueOf(metadata103.getDescription().getDescription()));
    }
}
